/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.PluginManager;
import de.renew.plugin.SoftDependencyListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SoftDependency
implements IPluginManagerListener {
    public static Logger logger = Logger.getLogger(SoftDependency.class);
    private String pluginService;
    private IPlugin provider;
    private String listenerClass;
    private SoftDependencyListener listener;
    private IPlugin caller;
    private PluginManager mgr;

    public SoftDependency(IPlugin iPlugin, String string, String string2) {
        this.caller = iPlugin;
        this.pluginService = string;
        this.listenerClass = string2;
        this.listener = null;
        this.provider = null;
        this.mgr = PluginManager.getInstance();
        logger.debug((Object)("Soft dependency from " + iPlugin + " to " + string + " registered, using " + string2 + "."));
        this.mgr.addPluginManagerListener(this);
        this.checkServiceAvailable();
    }

    public synchronized void discard() {
        logger.debug((Object)("Unregistering soft dependency from " + this.caller + " to " + this.pluginService + "."));
        this.mgr.removePluginManagerListener(this);
        this.fireServiceRemoved();
        this.listener = null;
    }

    public SoftDependencyListener getListener() {
        if (this.listener == null) {
            try {
                Class<?> clazz = Class.forName(this.listenerClass, true, this.mgr.getBottomClassLoader());
                try {
                    Constructor<?> constructor = clazz.getConstructor(IPlugin.class);
                    this.listener = (SoftDependencyListener)constructor.newInstance(this.caller);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.listener = (SoftDependencyListener)clazz.newInstance();
                    logger.debug((Object)("WARNING: Soft dependency from " + this.caller + " to " + this.pluginService + ": listener is created with" + " no-arg constructor of " + clazz + "."));
                }
                logger.debug((Object)("Soft dependency from " + this.caller + " to " + this.pluginService + ": created " + this.listener + "."));
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.warn((Object)("WARNING: Soft dependency from " + this.caller + " to " + this.pluginService + " could not be created: " + invocationTargetException.getTargetException() + "."));
                logger.debug((Object)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                logger.warn((Object)("WARNING: Soft dependency from " + this.caller + " to " + this.pluginService + " could not be created: " + exception + "."));
                logger.debug((Object)exception.getMessage(), (Throwable)exception);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                logger.warn((Object)("WARNING: Soft dependency from " + this.caller + " to " + this.pluginService + " could not be created: " + exceptionInInitializerError.getException() + "."));
                logger.debug((Object)exceptionInInitializerError.getMessage(), (Throwable)exceptionInInitializerError);
            }
        }
        return this.listener;
    }

    private void checkServiceAvailable() {
        Collection<IPlugin> collection = this.mgr.getPluginsProviding(this.pluginService);
        if (!collection.isEmpty()) {
            this.fireServiceAvailable(collection.iterator().next());
        } else {
            this.fireServiceRemoved();
        }
    }

    private void fireServiceAvailable(IPlugin iPlugin) {
        if (this.provider == null && this.getListener() != null) {
            logger.debug((Object)("Soft dependency from " + this.caller + " to " + iPlugin + " activated."));
            this.listener.serviceAvailable(iPlugin);
            this.provider = iPlugin;
        }
    }

    private void fireServiceRemoved() {
        if (this.provider != null && this.listener != null) {
            logger.debug((Object)("Soft dependency from " + this.caller + " to " + this.provider + " deactivated."));
            this.getListener().serviceRemoved(this.provider);
            this.provider = null;
        }
    }

    @Override
    public synchronized void serviceAdded(String string, IPlugin iPlugin) {
        if (string.equals(this.pluginService)) {
            Collection<IPlugin> collection = this.mgr.getPluginsProviding(this.pluginService);
            assert (!collection.isEmpty()) : "PluginManager misinformed soft dependency from " + this.caller + " to " + string;
            this.fireServiceAvailable(collection.iterator().next());
        }
    }

    @Override
    public synchronized void serviceRemoved(String string, IPlugin iPlugin) {
        if (string.equals(this.pluginService)) {
            this.fireServiceRemoved();
        }
    }
}

