/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.command.InfoCommand;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ListCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(InfoCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray.length > 0) {
            if ("-j".equals(stringArray[0]) || "j".equals(stringArray[0]) || "--jar".equals(stringArray[0]) || "jar".equals(stringArray[0])) {
                URL[] uRLArray;
                Iterator<IPlugin> iterator = PluginManager.getInstance().getPlugins().iterator();
                printStream.println("Plugin JAR-file locations:");
                while (iterator.hasNext()) {
                    printStream.println(((PluginAdapter)iterator.next()).getProperties().getURL());
                }
                System.out.println();
                printStream.println("Libraries JAR-file locations:");
                for (URL uRL : uRLArray = PluginManager.getInstance().getLibs()) {
                    printStream.println(uRL);
                }
            } else if ("-l".equals(stringArray[0]) || "l".equals(stringArray[0]) || "--long".equals(stringArray[0]) || "long".equals(stringArray[0])) {
                try {
                    for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
                        String string = "";
                        if (iPlugin instanceof PluginAdapter) {
                            PluginAdapter pluginAdapter = (PluginAdapter)iPlugin;
                            string = pluginAdapter.getVersion();
                        }
                        printStream.println(iPlugin.getProperties().getFilteredProperty(".date") + "\t " + iPlugin.getProperties().getFilteredProperty(".user") + "\t " + string + "\t " + iPlugin.getName());
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (NumberFormatException numberFormatException) {
                    printStream.println("cleanup canceled.");
                }
                catch (Exception exception) {
                    printStream.println("cleanup canceled: " + exception + "; " + exception.getMessage());
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            } else if ("-c".equals(stringArray[0]) || "c".equals(stringArray[0]) || "--comment".equals(stringArray[0]) || "comment".equals(stringArray[0])) {
                try {
                    for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
                        String string = iPlugin.getProperties().getFilteredProperty("comment");
                        if ("No comment given in etc/comment.txt".equals(string)) continue;
                        printStream.println(iPlugin.getName() + "\t " + string);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (NumberFormatException numberFormatException) {
                    printStream.println("cleanup canceled.");
                }
                catch (Exception exception) {
                    printStream.println("cleanup canceled: " + exception + "; " + exception.getMessage());
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            } else if ("-o".equals(stringArray[0]) || "o".equals(stringArray[0])) {
                List<IPlugin> list = PluginManager.getInstance().getPlugins();
                Collections.sort(list, new PluginNameComparator());
                Iterator<IPlugin> iterator = list.iterator();
                while (iterator.hasNext()) {
                    printStream.println(iterator.next());
                }
            }
            return;
        }
        Iterator<IPlugin> iterator = PluginManager.getInstance().getPlugins().iterator();
        while (iterator.hasNext()) {
            printStream.println(iterator.next());
        }
    }

    @Override
    public String getDescription() {
        return "lists all loaded plugins. Options: [-l| --long] for more information; [-c| --comment] to show compile comments; [-j|--jar] to show all JAR file locations;[-o] to show ordered list.";
    }

    public class PluginNameComparator
    implements Comparator<IPlugin> {
        @Override
        public int compare(IPlugin iPlugin, IPlugin iPlugin2) {
            String string = iPlugin.getName();
            String string2 = iPlugin2.getName();
            return string.compareTo(string2);
        }
    }
}

