/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LoadCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(LoadCommand.class);
    private IPlugin pluginTmp = null;

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        URL uRL = null;
        if (stringArray.length != 1 || "h".equals(stringArray[0]) || "-h".equals(stringArray[0]) || "--help".equals(stringArray[0]) || "--h".equals(stringArray[0]) || "-help".equals(stringArray[0])) {
            printStream.println("usage: load <url>\nexamples: \nload file:/path/to/location/name/plugin.cfg\nload file:/path/to/location/pluginname.jar\nload pluginname.jar\nload pluginname*");
        } else {
            Object object;
            String string = stringArray[0];
            try {
                Object object2;
                object = PluginProperties.getUserProperties().getProperty("pluginLocations");
                ArrayList<File> arrayList = new ArrayList<File>();
                if (object != null) {
                    object2 = ((String)object).split(File.pathSeparator);
                    for (Object object3 : object2) {
                        arrayList.add(new File((String)object3).getCanonicalFile());
                    }
                }
                arrayList.add(new File(PluginManager.getLoaderLocation().getPath() + "plugins").getCanonicalFile());
                object2 = new ArrayList();
                int n = 0;
                for (File file : arrayList) {
                    Object object3;
                    logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Plugin Location found: " + file.getAbsolutePath()));
                    if (!file.exists()) continue;
                    if (!string.endsWith("*")) {
                        object3 = "file:" + File.separator + File.separator + file.getAbsolutePath() + File.separator + string;
                        uRL = new URL((String)object3);
                        continue;
                    }
                    object3 = file.listFiles();
                    if (object3 == null) continue;
                    for (int i = 0; i < ((File[])object3).length; ++i) {
                        if (!object3[i].isDirectory() && object3[i].getName().toLowerCase().startsWith(string.toLowerCase().replace("*", ""))) {
                            logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Adding file to mached plugin list: " + object3[i].getAbsolutePath()));
                            ((ArrayList)object2).add(object3[i]);
                            n = Math.max(n, object3[i].getAbsolutePath().length());
                        }
                        if (!object3[i].isDirectory() || !object3[i].getName().toLowerCase().startsWith(string.toLowerCase().replace("*", ""))) continue;
                        logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Adding plugin.cfg file to mached directory plugin list: " + object3[i].getAbsolutePath()));
                        ((ArrayList)object2).add(new File(object3[i] + File.separator + "plugin.cfg"));
                        n = Math.max(n, object3[i].getAbsolutePath().length());
                    }
                }
                if (((ArrayList)object2).size() == 1) {
                    if (this.isLoaded((File)((ArrayList)object2).get(0))) {
                        if (this.pluginTmp != null) {
                            printStream.println("\n\tPlug-in \t" + this.pluginTmp.getName() + " [" + ((File)((ArrayList)object2).get(0)).getName() + "]\t already loaded.\n");
                        } else {
                            printStream.println("\n\tPlug-in \t" + ((File)((ArrayList)object2).get(0)).getName() + "\t already loaded.\n");
                        }
                        printStream.println("Stop command 'load " + stringArray[0] + "'.");
                        return;
                    }
                    uRL = new URL("file:" + File.separator + File.separator + ((File)((ArrayList)object2).get(0)).getAbsolutePath());
                }
                if (((ArrayList)object2).size() > 1) {
                    int n2 = this.selectFile(printStream, (ArrayList<File>)object2, stringArray[0], n);
                    if (n2 >= 0) {
                        uRL = new URL("file:" + File.separator + File.separator + ((File)((ArrayList)object2).get(n2)).getAbsolutePath());
                    } else {
                        return;
                    }
                }
                if (((ArrayList)object2).size() == 0) {
                    printStream.println("No match found for " + stringArray[0] + ".");
                    printStream.println("Stop command 'load " + stringArray[0] + "'.");
                    return;
                }
            }
            catch (Exception exception) {
                uRL = null;
            }
            try {
                logger.debug((Object)(LoadCommand.class.getSimpleName() + ": Trying to load plugin from URL: " + uRL));
                if (uRL == null) {
                    uRL = new URL(stringArray[0]);
                }
                if ((object = PluginManager.getInstance().loadPlugin(uRL)) != null) {
                    printStream.println("\n\tPlug-in: \t" + object.getName() + "\t successfully loaded.\n");
                } else {
                    printStream.println("Plug-in (" + uRL + ") not loaded. See log messages for details.");
                }
            }
            catch (MalformedURLException malformedURLException) {
                printStream.println("Malformed URL: " + malformedURLException.getMessage());
            }
            catch (Exception exception) {
                printStream.println("load failed: " + exception);
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private int selectFile(PrintStream printStream, ArrayList<File> arrayList, String string, int n) {
        String string2;
        InputStream inputStream = System.in;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        PrintStream printStream2 = printStream;
        printStream2.println("The following plug-ins were found for " + string + " : ");
        printStream2.println("");
        String string3 = "";
        for (int i = 0; string3.length() < n && i < 500; ++i) {
            string3 = string3 + " ";
        }
        string3 = string3 + "  ";
        String string4 = " Selection   Path " + string3 + " Status ";
        printStream2.println(string4);
        String string5 = "";
        for (int i = 0; string5.length() < string4.length() && i < 500; ++i) {
            string5 = string5 + "-";
        }
        printStream2.println(string5);
        printStream2.println("");
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = arrayList.get(i).getAbsolutePath();
            String string6 = this.isLoaded(arrayList.get(i)) ? "loaded" : "  --";
            String string7 = "";
            int n2 = n - string2.length() + 4;
            for (int j = 0; string7.length() < n2 && j < 100; ++j) {
                string7 = string7 + " ";
            }
            string7 = string7 + "  ";
            printStream2.println(" " + (i + 1) + "           " + string2 + " " + string7 + " " + string6);
        }
        printStream2.println("");
        printStream2.print("Press enter to stop loading plug-in, or type selection number: ");
        String string8 = null;
        string2 = "Stop  command 'load " + string + "'.";
        try {
            string8 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            printStream2.println("Could not load selected plug-in due to exception : " + iOException + ".");
            printStream2.println(string2);
            return -1;
        }
        if (string8 != null && string8.trim().length() > 0) {
            string8 = string8.trim();
            try {
                int n3 = Integer.parseInt(string8) - 1;
                if (n3 < 0 || n3 >= arrayList.size()) {
                    printStream2.println("Selection " + string8 + " not known.");
                    printStream2.println(string2);
                    return -1;
                }
                if (arrayList.get(n3) == null) {
                    printStream2.println("Selection " + n3 + " not known");
                    printStream2.println(string2);
                    return -1;
                }
                if (arrayList.get(n3) != null && this.isLoaded(arrayList.get(n3))) {
                    if (this.pluginTmp != null) {
                        printStream2.println("\n\tPlug-in \t" + this.pluginTmp.getName() + " [" + arrayList.get(0).getName() + "]\t already loaded.\n");
                    } else {
                        printStream2.println("\n\tPlug-in \t" + arrayList.get(n3).getName() + "\t already loaded.\n");
                    }
                    printStream2.println(string2);
                    return -1;
                }
                if (arrayList.get(n3) != null && !this.isLoaded(arrayList.get(n3))) {
                    return n3;
                }
            }
            catch (Exception exception) {
                printStream2.println("Selection " + string8 + " not known.");
                printStream2.println(string2);
                return -1;
            }
        }
        printStream2.println("No selection made.");
        printStream2.println(string2);
        return -1;
    }

    private boolean isLoaded(File file) {
        this.pluginTmp = null;
        String string = file.getAbsolutePath();
        List<IPlugin> list = PluginManager.getInstance().getPlugins();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = "";
            try {
                string2 = new File(list.get(i).getProperties().getURL().getFile()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!string2.contains(string)) continue;
            this.pluginTmp = list.get(i);
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Load a new plug-in. Type 'load -help' to get examples of usage.";
    }
}

