/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class FileFinder {
    private static Logger logger = Logger.getLogger(FileFinder.class);

    public static InputStream searchForRnwFileInJars(String string) {
        String string2 = FileFinder.getContent(string);
        if (string2 == null) {
            logger.warn((Object)"FileFinder.searchForRnwFileInJars : No net name set.");
            return null;
        }
        List<IPlugin> list = PluginManager.getInstance().getPlugins();
        for (IPlugin iPlugin : list) {
            InputStream inputStream;
            PluginProperties pluginProperties = iPlugin.getProperties();
            if (!pluginProperties.getBoolProperty("option.include.rnws") || (inputStream = FileFinder.searchForFileInJar(iPlugin, string2, "rnw")) == null) continue;
            return inputStream;
        }
        return null;
    }

    public static InputStream searchForFileInJars(String string, String string2) {
        String string3 = FileFinder.getContent(string);
        String string4 = FileFinder.getContent(string2);
        if (string3 == null || string4 == null) {
            if (string3 == null) {
                logger.warn((Object)"FileFinder.searchForFileInJars : No file name set.");
            }
            if (string4 == null) {
                logger.warn((Object)"FileFinder.searchForFileInJars : No extension set.");
            }
            return null;
        }
        List<IPlugin> list = PluginManager.getInstance().getPlugins();
        for (IPlugin iPlugin : list) {
            InputStream inputStream = FileFinder.searchForFileInJar(iPlugin, string3, string4);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public static InputStream getFileFromJarAsStream(URL uRL, String string) {
        try {
            JarFile jarFile = new JarFile(new File(uRL.toURI()));
            ZipEntry zipEntry = jarFile.getEntry(string);
            return zipEntry != null ? jarFile.getInputStream(zipEntry) : null;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error((Object)uRISyntaxException);
        }
        return null;
    }

    public static InputStream searchForFileInJar(IPlugin iPlugin, String string, String string2) {
        String string3 = FileFinder.getContent(string);
        String string4 = FileFinder.getContent(string2);
        if (iPlugin == null || string3 == null || string4 == null) {
            if (iPlugin == null) {
                logger.warn((Object)"FileFinder.searchForFileInJar : No plug-in set.");
            }
            if (string3 == null) {
                logger.warn((Object)"FileFinder.searchForFileInJar : No file name set.");
            }
            if (string4 == null) {
                logger.warn((Object)"FileFinder.searchForFileInJar : No extension set.");
            }
            return null;
        }
        if (string4.startsWith(".")) {
            string4 = string4.substring(1, string4.length());
        }
        if (string3.endsWith("." + string4)) {
            string3 = string3.replace("." + string4, "");
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(new File(iPlugin.getProperties().getURL().toURI()));
            ZipEntry zipEntry = jarFile.getEntry(string3 + "." + string4);
            return zipEntry != null ? jarFile.getInputStream(zipEntry) : null;
        }
        catch (IOException iOException) {
            logger.error((Object)"FileFinder.searchForFileInJar : IOException ", (Throwable)iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error((Object)"FileFinder.searchForFileInJar : URISyntaxException ", (Throwable)uRISyntaxException);
        }
        return null;
    }

    public static String getURLforFile(String string, String string2, ClassLoader classLoader) {
        String string3 = FileFinder.getContent(string);
        String string4 = FileFinder.getContent(string2);
        if (string4 == null || classLoader == null) {
            if (string4 == null) {
                logger.warn((Object)"FileFinder.getURLforFile : No file name set.");
            }
            if (classLoader == null) {
                logger.warn((Object)"FileFinder.getURLforFile : No class loader set.");
            }
            return null;
        }
        if (string3 != null && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (string3 == null) {
            string3 = "";
        }
        logger.debug((Object)("FileFinder.getURLforFile: looking for " + string3 + string4 + " ... "));
        URL uRL = classLoader.getResource(string3 + string4);
        if (uRL != null) {
            logger.debug((Object)("FileFinder.getURLforFile: found " + uRL));
            return uRL.toString();
        }
        logger.warn((Object)("FileFinder.getURLforFile: Missing file. Could not locate " + string3 + string4));
        return null;
    }

    public static List<String> getURLsforFile(String[] stringArray, String string, ClassLoader classLoader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = FileFinder.getContent(string);
        if (string2 == null || classLoader == null) {
            if (string2 == null) {
                logger.warn((Object)"FileFinder.getURLsforFile : No file name set.");
            }
            if (classLoader == null) {
                logger.warn((Object)"FileFinder.getURLsforFile : No class loader set.");
            }
            return arrayList;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = FileFinder.getURLforFile(stringArray[i], string2, classLoader);
                if (string3 == null) continue;
                arrayList.add(string3);
            }
        } else {
            String string4 = FileFinder.getURLforFile(null, string2, classLoader);
            if (string4 != null) {
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    private static String getContent(String string) {
        if (string != null && string.trim().length() > 0) {
            return string.trim();
        }
        return null;
    }
}

