/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.fa.FAFileFilter;
import de.renew.fa.figures.FAStateFigure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FADrawing
extends CPNDrawing
implements LayoutableDrawing {
    static final long serialVersionUID = -4229673070089970973L;
    public static Logger logger = Logger.getLogger(FADrawing.class);
    private static FilterContainer filterContainer;
    private transient int maxUsedID = 0;
    private transient Hashtable<Integer, Figure> usedIDs = new Hashtable();

    public static FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer((SimpleFileFilter)new FAFileFilter());
        }
        return filterContainer;
    }

    public synchronized void fillInGraph(GraphLayout graphLayout) {
        logger.debug((Object)("fillInGraph(GraphLayout) called with " + graphLayout));
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof FAStateFigure || figure instanceof TextFigure && ((TextFigure)figure).parent() == null) {
                graphLayout.addNode(figure);
            } else if (figure instanceof ConnectionFigure) {
                graphLayout.addEdge((ConnectionFigure)figure, 20);
            }
            logger.debug((Object)("added " + figure));
        }
    }

    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return FADrawing.getFilterContainer().getDefaultFileFilter();
    }

    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return FADrawing.getFilterContainer().getExportFileFilters();
    }

    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return FADrawing.getFilterContainer().getImportFileFilters();
    }

    public String getWindowCategory() {
        return "Finite Automata";
    }

    public Figure add(Figure figure) {
        logger.debug((Object)("add(Figure) called with " + figure));
        if (figure instanceof FigureWithID) {
            this.checkAndAssignID((FigureWithID)figure);
        }
        Figure figure2 = super.add(figure);
        return figure2;
    }

    private void checkAndAssignID(FigureWithID figureWithID) {
        int n;
        int n2 = n = figureWithID.getID();
        FigureWithID figureWithID2 = (FigureWithID)this.usedIDs.get(new Integer(n));
        if (figureWithID2 != null && figureWithID2 != figureWithID) {
            n2 = 0;
        }
        if (n2 == 0) {
            n2 = this.newUniqueID();
            figureWithID.setID(n2);
        }
        this.usedIDs.put(new Integer(n2), (Figure)figureWithID);
    }

    private int newUniqueID() {
        if (this.maxUsedID == 0) {
            this.recomputeIDCache();
        }
        ++this.maxUsedID;
        return this.maxUsedID;
    }
}

