/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.fa.AltPaletteCreator;
import de.renew.fa.FADrawing;
import de.renew.fa.FAFileFilter;
import de.renew.fa.FAInstanceDrawingFactory;
import de.renew.fa.FAPluginExtender;
import de.renew.fa.PaletteCreator;
import de.renew.fa.commands.ChangeDecorationCommand;
import de.renew.fa.commands.ChangeFADrawModeCommand;
import de.renew.fa.commands.ShowPaletteCommand;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FADrawMode;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.NullDecoration;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.fa.service.JflapExportFormat;
import de.renew.fa.service.XFAExportFormat;
import de.renew.fa.service.XFAImportFormat;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InscribableFigure;
import de.renew.gui.InstanceDrawingFactory;
import de.renew.gui.TextFigureCreator;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FAPlugin
extends PluginAdapter {
    private static Logger logger = Logger.getLogger(FAPlugin.class);
    private static final String KEY_USEINDICES = "de.renew.fa.useindices";
    private static final String KEY_STATE_PREFIX = "de.renew.fa.state-prefix";
    public static final String IMAGES = "images/";
    private Hashtable<Command, IPlugin> _commandList;
    private Vector<IPlugin> _pluginList = new Vector();
    private CommandMenu _menu;
    private JMenuItem _separator;
    private FAFigureCreator faFigureCreator = null;
    private boolean loaded;
    private PaletteCreator pc;

    public FAPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
        this._commandList = new Hashtable();
    }

    public FAPlugin(URL uRL) throws PluginException {
        super(uRL);
        this._commandList = new Hashtable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        this._menu = this.createMenu();
        CPNInstanceDrawing.registerInstanceDrawingFactory(FADrawing.class, (InstanceDrawingFactory)new FAInstanceDrawingFactory());
        if (drawPlugin != null) {
            MenuManager.SeparatorFactory separatorFactory = new MenuManager.SeparatorFactory("de.renew.fa");
            this._separator = separatorFactory.createSeparator();
            DrawPlugin drawPlugin2 = DrawPlugin.getCurrent();
            drawPlugin2.getMenuManager().registerMenu("Tools", this._separator);
            drawPlugin2.getMenuManager().registerMenu("Tools", (JMenuItem)this._menu);
            this.faFigureCreator = new FAFigureCreator();
            GuiPlugin.getCurrent().getFigureCreatorHolder().registerCreator((TextFigureCreator)this.faFigureCreator);
            if (drawPlugin != null) {
                DrawingTypeManager.getInstance().register("de.renew.fa.FADrawing", (SimpleFileFilter)new FAFileFilter());
            }
            try {
                boolean bl = PropertyHelper.getBoolProperty((Properties)this.getProperties(), (String)"de.renew.fa.init");
                logger.debug((Object)("init protperty is : " + bl));
                if (!bl) {
                    // empty if block
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            drawPlugin2.getImportHolder().addImportFormat((ImportFormat)new XFAImportFormat());
            drawPlugin2.getExportHolder().addExportFormat((ExportFormat)new XFAExportFormat());
            drawPlugin2.getExportHolder().addExportFormat((ExportFormat)new JflapExportFormat());
        }
    }

    public boolean cleanup() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin != null) {
            drawPlugin.getMenuManager().unregisterMenu(this._separator);
            drawPlugin.getMenuManager().unregisterMenu((JMenuItem)this._menu);
        }
        if (this.loaded) {
            this.pc.remove();
            this.loaded = false;
        }
        if (this.faFigureCreator != null) {
            GuiPlugin.getCurrent().getFigureCreatorHolder().unregisterCreator((TextFigureCreator)this.faFigureCreator);
            this.faFigureCreator = null;
        }
        return true;
    }

    public void create() {
        if (this.loaded) {
            this.pc.remove();
            this.loaded = false;
        } else {
            this.loadPalette();
        }
    }

    private void loadPalette() {
        if (FADrawMode.getInstance().getMode() == 0) {
            this.pc = new PaletteCreator("FAPalette");
            logger.debug((Object)"created standard palette");
        } else {
            this.pc = new AltPaletteCreator("FAPalette");
            logger.debug((Object)"created alt palette");
        }
        this.loaded = true;
    }

    public void switchPalette() {
        if (this.loaded) {
            this.pc.remove();
            this.loadPalette();
        }
    }

    private CommandMenu createMenu() {
        this._menu = new CommandMenu("FA Drawing Tool");
        Command command = new ShowPaletteCommand((IPlugin)this);
        this._menu.add(command, 54);
        this._commandList.put(command, (IPlugin)this);
        CommandMenu commandMenu = DrawApplication.createCommandMenu((String)"Decoration");
        command = new ChangeDecorationCommand("Start", new StartDecoration());
        commandMenu.add(command);
        this._commandList.put(command, (IPlugin)this);
        command = new ChangeDecorationCommand("End", new EndDecoration());
        commandMenu.add(command);
        this._commandList.put(command, (IPlugin)this);
        command = new ChangeDecorationCommand("Start/End", new StartEndDecoration());
        commandMenu.add(command);
        this._commandList.put(command, (IPlugin)this);
        command = new ChangeDecorationCommand("none", new NullDecoration());
        commandMenu.add(command);
        this._commandList.put(command, (IPlugin)this);
        this._menu.add((JMenuItem)commandMenu);
        command = new ChangeFADrawModeCommand((IPlugin)this);
        this._menu.add(command);
        this._commandList.put(command, (IPlugin)this);
        this._menu.addSeparator();
        command = new VersionInfoCommand((IPlugin)this);
        this._menu.add(command);
        this._menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.fa");
        this._commandList.put(command, (IPlugin)this);
        return this._menu;
    }

    public void deregisterPlugin(IPlugin iPlugin) {
        Enumeration<Command> enumeration = this._commandList.keys();
        while (enumeration.hasMoreElements()) {
            Command command = enumeration.nextElement();
            if (!(this._commandList.get(command) instanceof FAPluginExtender)) continue;
            this._menu.remove(command);
            this._commandList.remove(command);
        }
        this._pluginList.remove(iPlugin);
    }

    public void registerPlugin(IPlugin iPlugin) {
        this._pluginList.add(iPlugin);
        if (iPlugin instanceof FAPluginExtender) {
            Vector<Command> vector = ((FAPluginExtender)iPlugin).getMenuCommands();
            for (Command command : vector) {
                this._menu.add(command);
                this._commandList.put(command, iPlugin);
                logger.debug((Object)("Added command " + command.toString() + "\n of Plugin " + iPlugin));
            }
        }
    }

    public static FAPlugin getCurrent() {
        PluginManager pluginManager = PluginManager.getInstance();
        if (pluginManager == null) {
            return null;
        }
        return (FAPlugin)pluginManager.getPluginByName("Renew Finite Automata Base");
    }

    public boolean getUseIndices() {
        return this.getProperties().getBoolProperty(KEY_USEINDICES);
    }

    private class FAFigureCreator
    implements TextFigureCreator {
        private FAFigureCreator() {
        }

        public boolean canCreateDefaultInscription(InscribableFigure inscribableFigure) {
            if (inscribableFigure instanceof FAStateFigure) {
                return true;
            }
            return inscribableFigure instanceof FAArcConnection;
        }

        public boolean canCreateFigure(InscribableFigure inscribableFigure) {
            return this.canCreateDefaultInscription(inscribableFigure);
        }

        public TextFigure createTextFigure(InscribableFigure inscribableFigure) {
            if (inscribableFigure instanceof FAStateFigure) {
                return new FATextFigure(2);
            }
            if (inscribableFigure instanceof FAArcConnection) {
                return new FATextFigure(1);
            }
            return null;
        }

        public String getDefaultInscription(InscribableFigure inscribableFigure) {
            boolean bl = FAPlugin.this.getProperties().getBoolProperty(FAPlugin.KEY_USEINDICES);
            String string = FAPlugin.this.getProperties().getProperty(FAPlugin.KEY_STATE_PREFIX);
            String string2 = string = string == null ? "z" : string;
            if (inscribableFigure instanceof FAStateFigure) {
                CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
                int n = 0;
                if (cPNApplication != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    Drawing drawing = cPNApplication.drawing();
                    FigureEnumeration figureEnumeration = drawing.figures();
                    while (figureEnumeration.hasMoreElements()) {
                        FigureEnumeration figureEnumeration2;
                        Figure figure = figureEnumeration.nextFigure();
                        if (!(figure instanceof FAStateFigure) || !(figureEnumeration2 = ((FAStateFigure)figure).children()).hasMoreElements()) continue;
                        String string3 = ((TextFigure)figureEnumeration2.nextFigure()).getText();
                        hashSet.add(string3);
                    }
                    while (hashSet.contains(string + n) || hashSet.contains(string + "_" + n) || hashSet.contains(string + "_{" + n + "}")) {
                        ++n;
                    }
                }
                if (bl) {
                    return string + "_{" + n + "}";
                }
                return string + n;
            }
            if (inscribableFigure instanceof FAArcConnection) {
                return "a";
            }
            return null;
        }
    }
}

