/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.fa.FAInstanceDrawing;
import de.renew.fa.figures.FAArcConnection;
import de.renew.gui.InstanceFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FAArcInstanceConnection
extends AbstractFigure
implements InstanceFigure,
EventListener {
    public static Logger logger = Logger.getLogger(FAArcInstanceConnection.class);
    private FAArcConnection faArcConnection;
    private FAInstanceDrawing drawing;
    private TransitionInstanceAccessor transitionInstance;
    private boolean afterglow = false;
    private Thread afterglowThread;
    private AWTSynchronizedUpdate updateTask;
    private RemoteEventForwarder forwarder;

    public FAArcInstanceConnection(FAInstanceDrawing fAInstanceDrawing, FAArcConnection fAArcConnection, Hashtable<Serializable, ObjectAccessor> hashtable) {
        this.faArcConnection = fAArcConnection;
        this.drawing = fAInstanceDrawing;
        this.initialize(hashtable);
        this.updateTask = new AWTSynchronizedUpdate(new Runnable(){

            @Override
            public void run() {
                FAArcInstanceConnection.this.executeUpdate();
            }
        });
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> hashtable) {
        if (hashtable.size() != 1) {
            logger.error((Object)("Error: There are not excactly three net elements for the figure " + this));
            return;
        }
        Enumeration<ObjectAccessor> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ObjectAccessor objectAccessor = enumeration.nextElement();
            if (!(objectAccessor instanceof TransitionInstanceAccessor)) continue;
            this.transitionInstance = (TransitionInstanceAccessor)objectAccessor;
        }
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.transitionInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    public boolean isChangingState() {
        try {
            return this.transitionInstance.isFiring();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void draw(Graphics graphics) {
    }

    public Rectangle displayBox() {
        return this.faArcConnection.displayBox();
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    protected void basicMoveBy(int n, int n2) {
    }

    public boolean isHighlighted() {
        return this.isChangingState() || this.afterglow;
    }

    private void invalidateHighlight() {
        Figure figure = this.faArcConnection.getHighlightFigure();
        if (figure != null) {
            Rectangle rectangle = figure.displayBox();
            DrawingChangeEvent drawingChangeEvent = new DrawingChangeEvent((Drawing)this.drawing, rectangle);
            this.drawing.drawingInvalidated(drawingChangeEvent);
        }
    }

    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return vector;
    }

    private void executeUpdate() {
        logger.debug((Object)"executeUpdate() called");
        if (this.listener() != null) {
            this.afterglow = true;
            this.invalidate();
            this.invalidateHighlight();
            this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            final FAArcInstanceConnection fAArcInstanceConnection = this;
            this.afterglowThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(300L);
                        }
                        FAArcInstanceConnection.this.afterglow = false;
                        FAArcInstanceConnection.this.invalidate();
                        FAArcInstanceConnection.this.invalidateHighlight();
                        FAArcInstanceConnection.this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)fAArcInstanceConnection));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            SimulationThreadPool.getCurrent().execute((Runnable)this.afterglowThread);
        }
    }

    public void update() {
        if (this.updateTask != null) {
            this.updateTask.scheduleUpdate();
        }
    }
}

