/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.framework.ParentFigure;
import de.renew.fa.FAPlugin;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.gui.CPNTextFigure;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.apache.log4j.Logger;

public class FATextFigure
extends CPNTextFigure {
    static final long serialVersionUID = -7270464173137023567L;
    private static Logger logger = Logger.getLogger(FATextFigure.class);
    public static final FATextFigure Name = new FATextFigure(2);
    public static final FATextFigure Inscription = new FATextFigure(1);

    public FATextFigure() {
        this(1, true);
    }

    public FATextFigure(int n) {
        this(n, true);
        logger.debug((Object)("FATextFigure of type " + this.fType + " created"));
    }

    public FATextFigure(int n, boolean bl) {
        super(n, bl);
    }

    public FATextFigure(int n, String string) {
        this(n, true);
        this.setText(string);
    }

    protected void drawLine(Graphics graphics, int n) {
        Font font = this.getLineFont(n);
        graphics.setFont(font);
        boolean bl = FAPlugin.getCurrent().getUseIndices();
        int n2 = this.getLineBox((Graphics)graphics, (int)n).x;
        int n3 = this.getLineBox((Graphics)graphics, (int)n).y;
        String string = this.getLine(n);
        if (!bl || string == null || string.equals("")) {
            graphics.drawString(string, n2, n3 + FATextFigure.getMetrics((Font)font, (Graphics)graphics).getAscent());
        } else {
            AttributedString attributedString = this.getFAText(string);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawString(attributedString.getIterator(), n2, n3 + FATextFigure.getMetrics((Font)font, (Graphics)graphics).getAscent());
        }
    }

    private AttributedString getFAText(String string) {
        String string2 = string.replaceFirst("_\\{(.*)\\}", "$1");
        string2 = string2.replaceFirst("_", "");
        AttributedString attributedString = new AttributedString(string2);
        if (!"".equals(string)) {
            attributedString.addAttribute(TextAttribute.SIZE, (Integer)this.getAttribute("FontSize") + 2);
            if (this.getType() == 2) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, 0, string2.length());
            }
        }
        if (!string.contains("_")) {
            return attributedString;
        }
        if (!string.contains("{")) {
            int n = string.indexOf(95);
            attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, n, string2.length());
            return attributedString;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            if (bl) {
                if (c == '}') {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (c == '{') {
                    bl2 = true;
                    continue;
                }
            }
            if (bl && bl2) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, n + 0, n + 1);
            }
            ++n;
        }
        return attributedString;
    }

    public Dimension getLineDimension(int n, Graphics graphics) {
        FAPlugin fAPlugin = FAPlugin.getCurrent();
        boolean bl = false;
        if (fAPlugin != null) {
            bl = fAPlugin.getUseIndices();
        }
        if (!bl) {
            return super.getLineDimension(n, graphics);
        }
        FontMetrics fontMetrics = FATextFigure.getMetrics((Font)this.getLineFont(n), (Graphics)graphics);
        AttributedString attributedString = this.getFAText(this.getLine(n));
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), graphics);
        double d = 0.0;
        double d2 = 0.0;
        attributedCharacterIterator.first();
        for (int i = 0; i < attributedCharacterIterator.getEndIndex(); ++i) {
            char c = attributedCharacterIterator.current();
            if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') {
                d += (double)fontMetrics.charWidth(c) / 1.5;
                d2 = fontMetrics.getHeight() / 3;
            } else {
                d += (double)fontMetrics.charWidth(c);
            }
            attributedCharacterIterator.next();
        }
        return new Dimension((int)d, (int)rectangle2D.getBounds().getHeight() + (int)d2);
    }

    protected boolean canBeParent(int n, ParentFigure parentFigure) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return parentFigure instanceof FAArcConnection;
            }
            case 2: 
            case 3: {
                return parentFigure instanceof FAArcConnection || parentFigure instanceof FAStateFigure;
            }
        }
        return false;
    }

    public String getName() {
        String string = ((Object)((Object)this)).getClass().getName();
        int n = string.lastIndexOf(46) + 1;
        if (n > 0) {
            string = string.substring(n);
        }
        return string + "(" + this.getText() + ")";
    }

    public String toString() {
        return this.getText();
    }
}

