/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.model;

import de.renew.fa.FADrawing;
import de.renew.fa.model.Arc;
import de.renew.fa.model.ArcImpl;
import de.renew.fa.model.FA;
import de.renew.fa.model.Letter;
import de.renew.fa.model.LetterImpl;
import de.renew.fa.model.State;
import de.renew.fa.model.StateImpl;
import de.renew.fa.model.Word;
import de.renew.fa.model.WordImpl;
import de.renew.fa.util.FAHelper;
import de.renew.fa.util.LetterNameComparator;
import de.renew.fa.util.StateNameComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FAImpl
implements FA {
    private HashMap<String, Letter> alphabet = new HashMap();
    private HashMap<String, Arc> arcs = new HashMap();
    private String name = "";
    private HashMap<String, State> states = new HashMap();

    public FAImpl() {
    }

    public FAImpl(FADrawing fADrawing) {
    }

    @Override
    public Vector<State> endStates() {
        Iterator<State> iterator = this.getStates();
        Vector<State> vector = new Vector<State>();
        while (iterator.hasNext()) {
            State state = iterator.next();
            if (!state.isEndState()) continue;
            vector.add(state);
        }
        return vector;
    }

    @Override
    public Iterator<Letter> getAlphabet() {
        Vector<Letter> vector = new Vector<Letter>(this.alphabet.values());
        Collections.sort(vector, new LetterNameComparator());
        return vector.iterator();
    }

    @Override
    public Iterator<Arc> getArcs() {
        return this.arcs.values().iterator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public State getStateByName(String string) {
        return this.states.get(string);
    }

    @Override
    public Iterator<State> getStates() {
        Vector<State> vector = new Vector<State>(this.states.values());
        Collections.sort(vector, new StateNameComparator());
        return vector.iterator();
    }

    @Override
    public State[] getStatesAsArray() {
        return this.states.values().toArray(new State[this.states.size()]);
    }

    @Override
    public boolean hasArc(String string, String string2) {
        Iterator<Arc> iterator = this.getArcs();
        while (iterator.hasNext()) {
            Arc arc = iterator.next();
            if (!arc.getFrom().getName().equals(string) || !arc.getTo().getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLiteral(Word word) {
        return this.alphabet.containsKey(word.getName());
    }

    @Override
    public Arc newArc(State state, Word word, State state2) {
        if (state == null || word == null || state2 == null) {
            return null;
        }
        ArcImpl arcImpl = new ArcImpl(state, word, state2);
        this.arcs.put(arcImpl.getName(), arcImpl);
        return arcImpl;
    }

    @Override
    public Letter newLetter(String string) {
        LetterImpl letterImpl = new LetterImpl(string);
        if (!this.alphabet.containsKey(string)) {
            this.alphabet.put(string, letterImpl);
            return letterImpl;
        }
        return null;
    }

    @Override
    public State newState(String string) {
        if (this.states.containsKey(string)) {
            return null;
        }
        StateImpl stateImpl = new StateImpl(string);
        this.states.put(string, stateImpl);
        return stateImpl;
    }

    @Override
    public Word newWord(String string) {
        return new WordImpl(string);
    }

    public void setAlphabet(Iterator<Letter> iterator) {
        while (iterator.hasNext()) {
            Letter letter = iterator.next();
            this.newLetter(letter.getName());
        }
    }

    @Override
    public boolean setAsEndState(String string) {
        if (this.states.containsKey(string)) {
            this.getStateByName(string).setEndState(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean setAsStartState(String string) {
        if (this.states.containsKey(string)) {
            this.getStateByName(string).setStartState(true);
            return true;
        }
        return false;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setStates(Iterator<State> iterator) {
        while (iterator.hasNext()) {
            State state = iterator.next();
            this.newState(state.getName());
        }
    }

    @Override
    public Vector<State> startStates() {
        Iterator<State> iterator = this.getStates();
        Vector<State> vector = new Vector<State>();
        while (iterator.hasNext()) {
            State state = iterator.next();
            if (!state.isStartState()) continue;
            vector.add(state);
        }
        return vector;
    }

    public String toString() {
        return FAHelper.toProperties(this).toString();
    }

    @Override
    public int numberOfStates() {
        return this.states.values().size();
    }

    @Override
    public int numberOfArcs() {
        return this.arcs.size();
    }

    @Override
    public int numberOfLetters() {
        return this.alphabet.size();
    }
}

