/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import CH.ifa.draw.framework.Drawing;
import de.renew.fa.FADrawing;
import de.renew.fa.model.Arc;
import de.renew.fa.model.FA;
import de.renew.fa.model.FAImpl;
import de.renew.fa.model.Letter;
import de.renew.fa.model.State;
import de.renew.fa.model.Word;
import de.renew.fa.util.FAHelper;
import de.renew.gui.GuiPlugin;
import de.renew.util.StringUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class FAFileParser {
    private static Logger logger = Logger.getLogger(FAFileParser.class);
    protected String _fileName;

    public static void writeToXFA(OutputStream outputStream, FA fA) {
        block2: {
            Properties properties = FAHelper.toProperties(fA);
            try {
                properties.store(outputStream, "FA Model for Drawing: " + fA.getName());
            }
            catch (IOException iOException) {
                logger.error((Object)(FAFileParser.class.getName() + ": Could not write fa " + fA.getName() + " to file."));
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)(FAFileParser.class.getName() + ": "), (Throwable)iOException);
            }
        }
    }

    public static void writeToXFA(OutputStream outputStream, Drawing drawing) {
        if (drawing instanceof FADrawing) {
            FADrawing fADrawing = (FADrawing)drawing;
            FA fA = FAHelper.getModel(fADrawing);
            FAFileParser.writeToXFA(outputStream, fA);
            String string = FAFileParser.getLatexCode(fA);
            FAFileParser.producepdf(string, fA.getName());
        }
    }

    private static void producepdf(String string, String string2) {
        String[] stringArray;
        File file = null;
        try {
            file = File.createTempFile(string2, ".tex");
            stringArray = new PrintWriter(file);
            stringArray.write("\\documentclass[a4paper]{article}");
            stringArray.write("\\begin{document}");
            stringArray.write(string);
            stringArray.write("\\end{document}");
            stringArray.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (file != null && file.exists()) {
            stringArray = new String[]{"pdflatex", "-output-directory=" + file.getAbsoluteFile().getParent(), file.getAbsolutePath()};
            FAFileParser.runCommand(stringArray);
            String string3 = StringUtil.extendFileNameBy((String)file.getAbsolutePath(), (String)"pdf");
            try {
                Desktop.getDesktop().browse(new URI("file://" + string3));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }

    private static final int runCommand(String[] stringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        System.out.println("running command: " + stringBuffer.toString());
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (process != null) {
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return n;
    }

    private static String getLatexCode(FA fA) {
        StringBuffer stringBuffer = new StringBuffer();
        if (logger.isInfoEnabled()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Iterator<State> iterator;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            logger.info((Object)(FAFileParser.class.getName() + ": "));
            stringBuffer.append("\\newcommand{\\faname}{A}\n");
            stringBuffer.append("\\begin{eqnarray*}\n");
            stringBuffer.append("\\faname &:=& (Q,\\Sigma,\\delta,S_{0},F) \\\\\n");
            stringBuffer.append("Q &:=& \\{");
            Iterator<State> iterator2 = fA.getStates();
            if (iterator2.hasNext()) {
                object9 = iterator2.next();
                stringBuffer.append(FAFileParser.texify(object9.getName()));
            }
            while (iterator2.hasNext()) {
                object9 = iterator2.next();
                stringBuffer.append("," + FAFileParser.texify(object9.getName()));
            }
            stringBuffer.append("\\} \\\\\n");
            stringBuffer.append("\\Sigma&:=&\\{");
            object9 = fA.getAlphabet();
            if (object9.hasNext()) {
                object8 = (Letter)object9.next();
                stringBuffer.append(object8.getName());
            }
            while (object9.hasNext()) {
                object8 = (Letter)object9.next();
                stringBuffer.append("," + object8.getName());
            }
            stringBuffer.append("\\} \\\\\n");
            stringBuffer.append("S_{0}&:=&\\{");
            object8 = fA.startStates().iterator();
            if (object8.hasNext()) {
                object7 = (State)object8.next();
                stringBuffer.append(FAFileParser.texify(object7.getName()));
            }
            while (object8.hasNext()) {
                object7 = (State)object8.next();
                stringBuffer.append("," + FAFileParser.texify(object7.getName()));
            }
            stringBuffer.append("\\} \\\\\n");
            stringBuffer.append("F&:=&\\{");
            object7 = fA.endStates().iterator();
            if (object7.hasNext()) {
                object6 = (State)object7.next();
                stringBuffer.append(FAFileParser.texify(object6.getName()));
            }
            while (object7.hasNext()) {
                object6 = (State)object7.next();
                stringBuffer.append("," + FAFileParser.texify(object6.getName()));
            }
            stringBuffer.append("\\} \\\\\n");
            object6 = new HashMap();
            Iterator<State> iterator3 = fA.getStates();
            while (iterator3.hasNext()) {
                object5 = iterator3.next();
                ((HashMap)object6).put(object5, new HashMap());
                iterator = fA.getAlphabet();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    object3 = new Vector();
                    ((HashMap)((HashMap)object6).get(object5)).put(object4, object3);
                    object2 = fA.getArcs();
                    while (object2.hasNext()) {
                        Arc arc = object2.next();
                        if (!object5.equals(arc.getFrom()) || !arc.getInscription().toString().contains(object4.getName())) continue;
                        ((Vector)object3).add(arc.getTo());
                    }
                    if (((Vector)object3).isEmpty()) continue;
                    stringBuffer.append("\\delta(" + FAFileParser.texify(object5.getName()) + "," + (Letter)object4 + ")&:=& \\{");
                    boolean bl = false;
                    object = ((Vector)object3).iterator();
                    while (object.hasNext()) {
                        State state = (State)object.next();
                        if (bl) {
                            stringBuffer.append("," + FAFileParser.texify(state.getName()));
                            continue;
                        }
                        stringBuffer.append(FAFileParser.texify(state.getName()));
                        bl = true;
                    }
                    stringBuffer.append("\\} \\\\\n");
                }
            }
            stringBuffer.append("\\end{eqnarray*}\n");
            stringBuffer.append("$$\\delta:=\\bordermatrix{\n");
            object5 = fA.getAlphabet();
            stringBuffer.append("     ");
            while (object5.hasNext()) {
                iterator = (Letter)object5.next();
                stringBuffer.append(" & " + iterator.getName());
            }
            stringBuffer.append(" \\cr\n");
            iterator = fA.getStates();
            while (iterator.hasNext()) {
                object4 = iterator.next();
                stringBuffer.append(FAFileParser.texify(object4.getName()));
                object3 = fA.getAlphabet();
                while (object3.hasNext()) {
                    object2 = (Letter)object3.next();
                    Iterator iterator4 = ((Vector)((HashMap)((HashMap)object6).get(object4)).get(object2)).iterator();
                    stringBuffer.append(" & \\{");
                    while (iterator4.hasNext()) {
                        object = (State)iterator4.next();
                        stringBuffer.append(" " + FAFileParser.texify(object.getName()) + " ");
                    }
                    stringBuffer.append("\\} ");
                }
                stringBuffer.append(" \\cr\n");
            }
            stringBuffer.append("}.$$\n");
        }
        return stringBuffer.toString();
    }

    private static String texify(String string) {
        return string.replaceAll("(\\w)([\\d]+)", "$1_{$2}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Arc newArc(FA fA, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(:) ");
        State state = null;
        Word word = null;
        State state2 = null;
        if (!stringTokenizer.hasMoreTokens()) return null;
        String string2 = stringTokenizer.nextToken();
        state = fA.getStateByName(string2);
        if (!stringTokenizer.hasMoreTokens()) return null;
        string2 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            if ("lambda".equals(string2)) {
                string2 = "";
            }
            word = fA.newWord(string2);
            string2 = stringTokenizer.nextToken();
            state2 = fA.getStateByName(string2);
        } else {
            word = fA.newWord("");
            state2 = fA.getStateByName(string2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(FAFileParser.class.getName() + ": " + state + word + state2));
        }
        if (state == null) return null;
        if (word == null) return null;
        if (state2 != null) return fA.newArc(state, word, state2);
        return null;
    }

    private FA parseXFA(InputStream inputStream) {
        String string;
        Object object;
        String string2;
        String string3;
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        FAImpl fAImpl = new FAImpl();
        String string4 = (String)properties.get("Z");
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "[,] ");
        while (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
            fAImpl.newState(string3);
        }
        string3 = (String)properties.get("Sigma");
        stringTokenizer = new StringTokenizer(string3, "[,] ");
        while (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
            if (string2.length() == 1) {
                fAImpl.newLetter(string2);
                continue;
            }
            object = "Element \"" + string2 + "\" is not a single character. Ignoring element.";
            string = "Ignoring element";
            this.simpleMessage(string, (String)object);
        }
        string2 = (String)properties.get("K");
        stringTokenizer = new StringTokenizer(string2, "[,] ");
        while (stringTokenizer.hasMoreElements()) {
            object = (String)stringTokenizer.nextElement();
            if (this.newArc(fAImpl, (String)object) != null) continue;
            this.simpleMessage("Ignoring Arc", (String)object + " is not a valid arc name.");
        }
        object = (String)properties.get("Z_Start");
        stringTokenizer = new StringTokenizer((String)object, "[,] ");
        while (stringTokenizer.hasMoreElements()) {
            string = (String)stringTokenizer.nextElement();
            if (fAImpl.getStateByName(string) != null) {
                fAImpl.getStateByName(string).setStartState(true);
                continue;
            }
            this.simpleMessage("Ignoring start state attribute", string + " is not in the set of states.");
        }
        string = (String)properties.get("Z_End");
        stringTokenizer = new StringTokenizer(string, "[,] ");
        while (stringTokenizer.hasMoreElements()) {
            String string5 = (String)stringTokenizer.nextElement();
            if (fAImpl.getStateByName(string5) != null) {
                fAImpl.getStateByName(string5).setEndState(true);
                continue;
            }
            this.simpleMessage("Ignoring end state attribute", string5 + " is not in the set of states.");
        }
        return fAImpl;
    }

    public FA parseXFA(InputStream inputStream, String string) {
        FA fA = this.parseXFA(inputStream);
        fA.setName(StringUtil.stripFilenameExtension((String)string));
        if (logger.isInfoEnabled()) {
            logger.info((Object)(FAFileParser.class.getName() + "------ FA Check Name1: " + fA.getName() + " ----------------------------\n\n" + fA.toString()));
        }
        return fA;
    }

    public FA parseXFA(String string) {
        FA fA = new FAImpl();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            fA = this.parseXFA(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        fA.setName(StringUtil.stripFilenameExtension((String)string));
        if (logger.isInfoEnabled()) {
            logger.info((Object)(FAFileParser.class.getName() + "------ FA Check Name2: " + fA.getName() + " ----------------------------\n\n" + fA.toString()));
        }
        return fA;
    }

    private void simpleMessage(String string, String string2) {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(FAFileParser.class.getName() + ": " + string + ": " + string2));
            }
            return;
        }
        JOptionPane.showMessageDialog(guiPlugin.getGuiFrame(), string2, string, 2, new ImageIcon(guiPlugin.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
    }

    public static void main(String[] stringArray) {
        String string = "z001aaa44";
        System.out.println(string.replaceAll("(\\w)([\\d]+)", "$1_{$2}"));
    }
}

