/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatAbstract;
import de.renew.fa.XFAFileFilter;
import de.renew.fa.service.XFAFormat;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class XFAImportFormat
extends ImportFormatAbstract
implements ImportFormat {
    public XFAImportFormat() {
        super("XFA", (FileFilter)((Object)new XFAFileFilter()));
    }

    protected Drawing[] importFile(URL uRL) throws Exception {
        Drawing[] drawingArray = null;
        if (uRL != null) {
            FileInputStream fileInputStream = new FileInputStream(new File(uRL.getFile()));
            XFAFormat xFAFormat = new XFAFormat();
            drawingArray = xFAFormat.parse(fileInputStream, StringUtil.getFilename((String)uRL.getPath()));
            fileInputStream.close();
        }
        assert (drawingArray != null) : "Failure in XFAImportFormat: result == null";
        return drawingArray;
    }

    public Drawing[] importFiles(URL[] uRLArray) throws Exception {
        Drawing[] drawingArray;
        Vector<Drawing[]> vector = new Vector<Drawing[]>();
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            drawingArray = this.importFile(uRL);
            vector.add(drawingArray);
        }
        Iterator iterator = vector.iterator();
        int n = vector.size();
        drawingArray = new Drawing[vector.size()];
        while (iterator.hasNext()) {
            Drawing[] drawingArray2 = (Drawing[])iterator.next();
            for (int i = 0; i < drawingArray2.length; ++i) {
                drawingArray[--n] = drawingArray2[i];
            }
        }
        assert (drawingArray != null) : "Failure in XFAImportFormat: result == null";
        return drawingArray;
    }
}

