/*
 * Decompiled with CFR 0.152.
 */
package de.renew.faformalism.compiler;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableExpression;
import de.renew.faformalism.shadow.FAShadowLookupExtension;
import de.renew.faformalism.shadow.ShadowFAArc;
import de.renew.faformalism.shadow.ShadowFAState;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.SingleJavaNetCompiler;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ExpressionTokenSource;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.Arc;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.SyntaxException;
import de.renew.util.Types;
import de.renew.util.Value;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SingleFANetCompiler
extends SingleJavaNetCompiler {
    private static Logger logger = Logger.getLogger(SingleFANetCompiler.class);
    private static final Value valueActive = new Value((Object)new Integer(1));
    private ExpressionTokenSource tokenSource;
    private static final LocalVariable letter = new LocalVariable("a");
    private static final VariableExpression letterExpr = new VariableExpression(Types.UNTYPED, letter);
    public static final String arcInscriptionPattern = "action System.out.println(%s);";
    private static int stateNum = 0;
    private static int transNum = 0;

    public SingleFANetCompiler() {
        this(false, false, false);
    }

    public SingleFANetCompiler(boolean bl, boolean bl2, boolean bl3) {
        super(bl, bl2, bl3);
        try {
            this.tokenSource = new ExpressionTokenSource(((TypedExpression)this.parseFAStateInscription("[]").iterator().next()).getExpression());
        }
        catch (SyntaxException syntaxException) {
            syntaxException.printStackTrace();
        }
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        if (this.hasMultipleStartstates(shadowNet.elements().iterator())) {
            logger.debug((Object)"Found multiple startstate! ~~~~~~~~~~~~~\u00ab\u00ab\u00ab");
            throw new SyntaxException("Cannot simulate automaton with multiple startstates.");
        }
        Net net = this.getLookup().getNet(shadowNet.getName());
        logger.debug((Object)("compile(ShadowNet) compiling " + net));
        this.parseDeclarations(shadowNet);
        for (ShadowNetElement shadowNetElement : shadowNet.elements()) {
            if (!(shadowNetElement instanceof ShadowFAState)) continue;
            this.compile((ShadowFAState)shadowNetElement, net);
        }
        logger.debug((Object)"\u00bb~ All shadow states compiled ~\u00ab");
        for (ShadowNetElement shadowNetElement : shadowNet.elements()) {
            if (!(shadowNetElement instanceof ShadowFAArc)) continue;
            this.compile((ShadowFAArc)shadowNetElement, net);
        }
        logger.debug((Object)"\u00bb~ All shadow states compiled ~\u00ab");
        logger.debug((Object)("\u00bb\u00bb~ Compilation of " + shadowNet.getName() + " finished! ~\u00ab\u00ab"));
    }

    protected void compile(ShadowFAState shadowFAState, Net net) throws SyntaxException {
        logger.debug((Object)("compile(ShadowFAState, Net) compiling " + shadowFAState));
        Object object = shadowFAState.getName();
        if (object == null) {
            object = "State" + ++stateNum;
        }
        Place place = new Place(net, (String)object, new NetElementID(shadowFAState.getID()));
        place.setTrace(shadowFAState.getTrace());
        if (shadowFAState.stateType == 1 || shadowFAState.stateType == 3) {
            place.add((TokenSource)this.tokenSource);
        }
        FAShadowLookupExtension.lookup(this.lookup).set(shadowFAState, place);
        this.compileFAStateInscriptions(shadowFAState, place);
    }

    protected void compileFAStateInscriptions(ShadowFAState shadowFAState, Place place) throws SyntaxException {
        logger.debug((Object)("compileFAStateInscriptions(ShadowFAState, Place) called with " + shadowFAState + " and " + place));
        for (ShadowNetElement shadowNetElement : shadowFAState.elements()) {
            logger.debug((Object)(this + " has " + shadowNetElement + " as child"));
            if (shadowNetElement instanceof ShadowInscription) {
                String string = ((ShadowInscription)shadowNetElement).inscr;
                try {
                    for (Object object : this.parseFAStateInscription(string)) {
                        if (!(object instanceof TypedExpression)) continue;
                        TypedExpression typedExpression = (TypedExpression)object;
                        Expression expression = null;
                        try {
                            expression = JavaNetHelper.makeCastedOutputExpression((Class)Types.UNTYPED, (TypedExpression)typedExpression);
                        }
                        catch (SyntaxException syntaxException) {
                            throw syntaxException.addObject((Object)shadowNetElement);
                        }
                        place.add((TokenSource)new ExpressionTokenSource(expression));
                        logger.debug((Object)("Added " + expression + " to " + shadowFAState));
                    }
                    continue;
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject((Object)shadowNetElement);
                }
            }
            if (shadowNetElement instanceof ShadowFAArc) continue;
            throw new SyntaxException("Unsupported place inscription: " + shadowNetElement.getClass()).addObject((Object)shadowFAState).addObject((Object)shadowNetElement);
        }
    }

    private Collection<Object> parseFAStateInscription(String string) throws SyntaxException {
        logger.debug((Object)("parseFAStateInscription(String) called with " + string));
        if (string != null && !string.equals("")) {
            logger.debug((Object)("FAState has inscription \u00bb " + string + " \u00ab"));
            InscriptionParser inscriptionParser = this.makeParser(string);
            inscriptionParser.setDeclarationNode(this.declaration);
            try {
                return inscriptionParser.PlaceInscription();
            }
            catch (ParseException parseException) {
                throw SingleFANetCompiler.makeSyntaxException((ParseException)parseException);
            }
        }
        return Collections.emptySet();
    }

    protected void compile(ShadowFAArc shadowFAArc, Net net) throws SyntaxException {
        logger.debug((Object)("compile(ShadowFAArc, Net) compiling " + shadowFAArc));
        logger.debug((Object)("ShadowFAArcs name is " + shadowFAArc.getName()));
        Object object = shadowFAArc.toString();
        if (object == null) {
            object = "Arc" + ++transNum;
        }
        Transition transition = new Transition(net, (String)object, new NetElementID(shadowFAArc.getID()));
        FAShadowLookupExtension.lookup(this.lookup).set(shadowFAArc, transition);
        Place place = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc.src);
        Arc arc = new Arc(place, transition, -1, (Expression)letterExpr, ConstantExpression.doubleZeroExpression);
        arc.setTrace(shadowFAArc.getTrace());
        transition.add((TransitionInscription)arc);
        Place place2 = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc.dest);
        arc = new Arc(place2, transition, 1, (Expression)letterExpr, ConstantExpression.doubleZeroExpression);
        arc.setTrace(shadowFAArc.getTrace());
        transition.add((TransitionInscription)arc);
        this.compileFAArcInscriptions(shadowFAArc);
    }

    protected void compileFAArcInscriptions(ShadowFAArc shadowFAArc) throws SyntaxException {
        logger.debug((Object)("compileFAArcInscriptions(ShadowFAArc) called with " + shadowFAArc));
        Vector<TransitionInscription> vector = new Vector<TransitionInscription>();
        Iterator iterator = shadowFAArc.elements().iterator();
        Transition transition = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc);
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ShadowInscription)) continue;
            ShadowInscription shadowInscription = (ShadowInscription)object;
            vector.addAll(this.parseFAArcInscription(shadowInscription, transition));
        }
        for (TransitionInscription transitionInscription : vector) {
            transition.add(transitionInscription);
        }
    }

    private Collection<TransitionInscription> parseFAArcInscription(ShadowInscription shadowInscription, Transition transition) throws SyntaxException {
        logger.debug((Object)("parseFAArcInscription(ShadowInscription, Transition) called with " + shadowInscription + " and " + transition));
        String string = this.checkTransitionInscription(shadowInscription.inscr, false, shadowInscription.getNet());
        logger.debug((Object)("Parsed inscription was \u00bb " + string + " \u00ab"));
        return this.makeInscriptions(shadowInscription.inscr, transition, true);
    }

    private boolean hasMultipleStartstates(Iterator<ShadowNetElement> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ShadowNetElement shadowNetElement = iterator.next();
            if (!(shadowNetElement instanceof ShadowFAState)) continue;
            ShadowFAState shadowFAState = (ShadowFAState)shadowNetElement;
            if (shadowFAState.stateType != 1 && shadowFAState.stateType != 3 || ++n <= 1) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

