/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateContainer
implements Iterable<Map.Entry<AnyObjectId, List<String>>> {
    protected final RevCommit commit;
    protected final Map<AnyObjectId, List<String>> objects;

    protected DuplicateContainer(RevCommit commit) {
        this.commit = commit;
        this.objects = new HashMap<AnyObjectId, List<String>>();
    }

    protected DuplicateContainer include(AnyObjectId id, String path) {
        List<String> paths = this.objects.get(id);
        if (paths == null) {
            paths = new ArrayList<String>(2);
            this.objects.put(id, paths);
        }
        paths.add(path);
        return this;
    }

    protected boolean validate() {
        Iterator<Map.Entry<AnyObjectId, List<String>>> entries = this.iterator();
        while (entries.hasNext()) {
            if (entries.next().getValue().size() >= 2) continue;
            entries.remove();
        }
        return !this.objects.isEmpty();
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public Map<AnyObjectId, List<String>> getDuplicates() {
        return this.objects;
    }

    @Override
    public Iterator<Map.Entry<AnyObjectId, List<String>>> iterator() {
        return this.objects.entrySet().iterator();
    }

    public int getTotal() {
        int total = 0;
        for (List<String> dupe : this.objects.values()) {
            total += dupe.size();
        }
        return total;
    }
}

