/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.FileMatchSorter;
import de.renew.refactoring.edit.IteratorEditor;
import de.renew.refactoring.match.FileMatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class FileEditor
extends IteratorEditor<FileMatch, Void> {
    private static Logger logger = Logger.getLogger(FileEditor.class);

    public FileEditor(List<FileMatch> list) {
        super(new FileMatchSorter().sorted(list));
    }

    @Override
    public String getCurrentEditString() {
        return ((FileMatch)this.getCurrentEdit()).getFile().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void performEdit(FileMatch fileMatch) {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        File file = fileMatch.getFile();
        try {
            File file2 = new File(file.getPath() + "tmp");
            file2.createNewFile();
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            String string = bufferedReader.readLine();
            int n = 1;
            while (string != null) {
                String string2 = n == fileMatch.getLine() ? this.editLine(string, fileMatch) : string;
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string = bufferedReader.readLine();
                ++n;
            }
            if (file.delete() && file2.renameTo(file)) {
                logger.info((Object)("Replacing file successful: " + file));
            }
        }
        catch (IOException iOException) {
            logger.error((Object)("I/O Error occured while trying to replace " + file + "."));
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    protected abstract String editLine(String var1, FileMatch var2);
}

