/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.apache.log4j.Logger;

public class RestrictedEditingFilters {
    private static Logger logger = Logger.getLogger(RestrictedEditingFilters.class);
    private JTextComponent _textField;
    private final int _startIndex;
    private int _endIndex;
    private RestrictedEditingNavigationFilter _navigationFilter;
    private RestrictedEditingDocumentFilter _documentFilter;

    public RestrictedEditingFilters(JTextComponent jTextComponent, int n, int n2) {
        this._textField = jTextComponent;
        this._startIndex = n;
        this._endIndex = n2;
        this._navigationFilter = new RestrictedEditingNavigationFilter();
        this._documentFilter = new RestrictedEditingDocumentFilter();
    }

    public NavigationFilter getNavigationFilter() {
        return this._navigationFilter;
    }

    public DocumentFilter getDocumentFilter() {
        return this._documentFilter;
    }

    public int getStartIndex() {
        return this._startIndex;
    }

    public synchronized int getEndIndex() {
        return this._endIndex;
    }

    private synchronized void moveEndIndex(int n) {
        this._endIndex += n;
    }

    private synchronized boolean positionIsAllowed(int n) {
        return n >= this._startIndex && n <= this._endIndex;
    }

    private synchronized int allowedPositionNear(int n) {
        if (this.positionIsAllowed(n)) {
            return n;
        }
        return n > this._endIndex ? this._endIndex : this._startIndex;
    }

    class RestrictedEditingDocumentFilter
    extends DocumentFilter {
        RestrictedEditingDocumentFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (RestrictedEditingFilters.this.positionIsAllowed(n) && RestrictedEditingFilters.this.positionIsAllowed(n + n2)) {
                RestrictedEditingFilters.this.moveEndIndex(-n2);
                super.remove(filterBypass, n, n2);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (RestrictedEditingFilters.this.positionIsAllowed(n)) {
                RestrictedEditingFilters.this.moveEndIndex(string.length());
            }
            super.insertString(filterBypass, n, string, attributeSet);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (RestrictedEditingFilters.this.positionIsAllowed(n) && RestrictedEditingFilters.this.positionIsAllowed(n + n2)) {
                RestrictedEditingFilters.this.moveEndIndex(string.length() - n2);
            }
            super.replace(filterBypass, n, n2, string, attributeSet);
        }
    }

    class RestrictedEditingNavigationFilter
    extends NavigationFilter {
        RestrictedEditingNavigationFilter() {
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            super.setDot(filterBypass, RestrictedEditingFilters.this.allowedPositionNear(n), bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            super.moveDot(filterBypass, RestrictedEditingFilters.this.allowedPositionNear(n), bias);
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = super.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
            return RestrictedEditingFilters.this.allowedPositionNear(n3);
        }
    }
}

