/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import java.util.regex.Pattern;

final class Patterns {
    static final String WHITESPACE = "\\s*";
    static final String PARENTHESES = "\\(.*\\)";
    static final Pattern NAME_PATTERN = Pattern.compile(Patterns.addWhitespace("\\w[\\w\\d]*"));
    static final Pattern UPLINK_PATTERN = Pattern.compile("(^\\s*|;\\s*):" + Patterns.addWhitespace(NAME_PATTERN) + "\\(.*\\)");
    static final Pattern DOWNLINK_PATTERN = Pattern.compile(NAME_PATTERN + Patterns.addWhitespace(":") + Patterns.addWhitespace(NAME_PATTERN) + "\\(.*\\)");
    static final Pattern DOWNLINK_TO_THIS_PATTERN = Pattern.compile(Patterns.addWhitespace("this") + Patterns.addWhitespace(":") + Patterns.addWhitespace(NAME_PATTERN) + "\\(.*\\)");
    static final String DOWNLINK_BEFORE_CHANNEL_NAME = Patterns.addWhitespace(NAME_PATTERN) + ":";
    static final String OPENING_PAR = Patterns.addWhitespace("\\(");
    static final String CLOSING_PAR = Patterns.addWhitespace("\\)");
    static final String PARAM = Patterns.addWhitespace("(([\\w]+[\\w\\d\\s]*)|(\\[.*\\]))");

    Patterns() {
    }

    static final String addWhitespace(String string) {
        return WHITESPACE + string + WHITESPACE;
    }

    static final String addWhitespace(Pattern pattern) {
        return WHITESPACE + pattern + WHITESPACE;
    }
}

