/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.gui.GuiPlugin;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.renamechannel.NoLinkSelectedException;
import de.renew.refactoring.renamechannel.RenameChannelEditor;
import de.renew.refactoring.renamechannel.RenameChannelReferencingLinkFinder;
import de.renew.refactoring.renamechannel.RenameChannelSelectedLinkFinder;
import de.renew.refactoring.search.range.DrawingSearchRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RenameChannelRefactoring {
    private static Logger logger = Logger.getLogger(RenameChannelRefactoring.class);
    private final LinkParser _parser;
    private final List<LinkMatch> _selectedLinks;
    private final Drawing _initialDrawing;
    private LinkMatch _selectedLink;
    private String _newChannelName;
    private DrawingSearchRange _searchRange;
    private RenameChannelReferencingLinkFinder _linkFinder;
    private RenameChannelEditor _editor;
    private List<LinkMatch> _linksToReplace;
    private Set<Drawing> _changedDrawings = new HashSet<Drawing>();

    public RenameChannelRefactoring(LinkParser linkParser, Drawing drawing, List<Figure> list) throws NoLinkSelectedException {
        this._parser = linkParser;
        this._initialDrawing = drawing;
        this._selectedLinks = new RenameChannelSelectedLinkFinder(this._parser, drawing, list).findSelectedLinks();
        if (this._selectedLinks.size() == 0) {
            throw new NoLinkSelectedException();
        }
    }

    private RenameChannelReferencingLinkFinder getLinkFinder() {
        if (this._linkFinder == null) {
            this._linkFinder = new RenameChannelReferencingLinkFinder(this._parser, this.getOldChannelName(), this.getParameterCount(), this._searchRange);
        }
        return this._linkFinder;
    }

    private void invalidateLinkFinder() {
        this._linkFinder = null;
    }

    public int getNumberOfDrawingsToSearch() {
        return this.getLinkFinder().getNumberOfItemsToSearch();
    }

    public boolean hasNextDrawingToSearch() {
        return this.getLinkFinder().hasNextItemToSearch();
    }

    public List<LinkMatch> findLinksInNextDrawing() {
        return (List)this.getLinkFinder().searchNextItem();
    }

    public String getCurrentlySearchedDrawingName() {
        return this.getLinkFinder().getCurrentItemString();
    }

    public int getReferencingLinkFinderProgress() {
        return this.getLinkFinder().getProgress();
    }

    private RenameChannelEditor getEditor() {
        if (this._editor == null) {
            this._editor = new RenameChannelEditor(this._linksToReplace, this._newChannelName);
        }
        return this._editor;
    }

    private void invalidateEditorAndChangedDrawings() {
        this._editor = null;
        this._changedDrawings = new HashSet<Drawing>();
    }

    public int getNumberOfEdits() {
        return this.getEditor().getNumberOfEdits();
    }

    public boolean hasNextEdit() {
        return this.getEditor().hasNextEdit();
    }

    public void performNextEdit() {
        this._changedDrawings.add((Drawing)this.getEditor().performNextEdit());
    }

    public int getEditorProgress() {
        return this.getEditor().getProgress();
    }

    public String getCurrentlyEditedDrawingName() {
        return this.getEditor().getCurrentEditString();
    }

    public void saveChangedDrawings() {
        for (Drawing drawing : this._changedDrawings) {
            boolean bl = DrawingFileHelper.saveDrawing((Drawing)drawing, (File)drawing.getFilename(), (StatusDisplayer)GuiPlugin.getCurrent().getGui());
            logger.debug((Object)("Saving drawing: " + drawing.getFilename() + ", success: " + bl));
        }
    }

    public Drawing getInitialDrawing() {
        return this._initialDrawing;
    }

    public List<LinkMatch> getSelectedLinks() {
        return Collections.unmodifiableList(this._selectedLinks);
    }

    public String getOldChannelName() {
        return this._parser.findChannelName(this._selectedLink.getText()).match();
    }

    public int getParameterCount() {
        return this._parser.findParameterCount(this._selectedLink.getText());
    }

    public LinkMatch getSelectedLink() {
        return this._selectedLink;
    }

    public void setSelectedLink(LinkMatch linkMatch) {
        this._selectedLink = linkMatch;
    }

    public boolean isSelectedLinkUplink() {
        return this._selectedLink instanceof UplinkMatch;
    }

    public boolean isValidChannelName(String string) {
        if (this.getOldChannelName().equals(string)) {
            return false;
        }
        return this._parser.isValidChannelName(string);
    }

    public String getNewChannelName() {
        return this._newChannelName;
    }

    public void setNewChannelName(String string) {
        this._newChannelName = string;
        this.invalidateLinkFinder();
    }

    public DrawingSearchRange getSearchRange() {
        return this._searchRange;
    }

    public void setSearchRange(DrawingSearchRange drawingSearchRange) {
        this._searchRange = drawingSearchRange;
    }

    public List<LinkMatch> getLinksToReplace() {
        return this._linksToReplace;
    }

    public void setLinksToReplace(List<LinkMatch> list) {
        this._linksToReplace = list;
        this.invalidateEditorAndChangedDrawings();
    }

    public void restorePreviousTexts() {
        this._changedDrawings = null;
        this._editor.restorePreviousTexts();
    }

    public List<Drawing> getChangedDrawings() {
        return new ArrayList<Drawing>(this._changedDrawings);
    }
}

