/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.renamevariable.VariableNameMatch;
import de.renew.refactoring.search.DrawingSearcher;
import de.renew.refactoring.search.range.SingleDrawingSearchRange;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class RenameVariableReferenceFinder
extends DrawingSearcher<VariableNameMatch> {
    private static Logger logger = Logger.getLogger(RenameVariableReferenceFinder.class);
    private final VariableParser _parser;
    private final String _name;

    RenameVariableReferenceFinder(VariableParser variableParser, Drawing drawing, String string) {
        super(new SingleDrawingSearchRange(drawing));
        this._parser = variableParser;
        this._name = string;
    }

    @Override
    protected List<VariableNameMatch> searchDrawing(Drawing drawing) {
        ArrayList<VariableNameMatch> arrayList = new ArrayList<VariableNameMatch>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof CPNTextFigure)) continue;
            CPNTextFigure cPNTextFigure = (CPNTextFigure)figure;
            String string = cPNTextFigure.getText();
            List<StringMatch> list = figure instanceof DeclarationFigure ? this._parser.findVariablesInDeclarationNode() : this._parser.findVariables(string);
            for (StringMatch stringMatch : list) {
                if (!stringMatch.match().equals(this._name)) continue;
                logger.debug((Object)("found reference: " + stringMatch));
                arrayList.add(new VariableNameMatch(drawing, cPNTextFigure, stringMatch));
            }
        }
        return arrayList;
    }
}

