/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSwitchCommand
extends SVNCommand {
    public SVNSwitchCommand() {
        super("switch", new String[]{"sw", "relocate"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.SET_DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.DIFF3_CMD);
        options.add(SVNOption.RELOCATE);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.IGNORE_ANCESTRY);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.ACCEPT);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNPath switchURL;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        if (this.getSVNEnvironment().isRelocate()) {
            if (this.getSVNEnvironment().getDepth() != SVNDepth.UNKNOWN) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--relocate and --depth are mutually exclusive");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            this.relocate(targets);
            return;
        }
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        if (targets.size() > 2) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR), (SVNLogType)SVNLogType.CLIENT);
        }
        if (!(switchURL = new SVNPath(targets.get(0), true)).isURL()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.BAD_URL, (String)"''{0}'' doesn not appear to be a URL", (Object)switchURL.getTarget()), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNPath target = targets.size() == 1 ? new SVNPath("") : new SVNPath(targets.get(1));
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment(), false, false, false);
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)printer);
        }
        SVNDepth depth = this.getSVNEnvironment().getDepth();
        boolean depthIsSticky = false;
        if (this.getSVNEnvironment().getSetDepth() != SVNDepth.UNKNOWN) {
            depth = this.getSVNEnvironment().getSetDepth();
            depthIsSticky = true;
        }
        boolean ignoreAncestry = this.getSVNEnvironment().isIgnoreAncestry();
        client.doSwitch(target.getFile(), switchURL.getURL(), switchURL.getPegRevision(), this.getSVNEnvironment().getStartRevision(), depth, this.getSVNEnvironment().isForce(), depthIsSticky, ignoreAncestry);
        if (!this.getSVNEnvironment().isQuiet()) {
            StringBuffer status = new StringBuffer();
            printer.printConflictStatus(status);
            this.getSVNEnvironment().getOut().print(status);
        }
        if (printer.hasExternalErrors()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ERROR_PROCESSING_EXTERNALS, (String)"Failure occurred processing one or more externals definitions"), (SVNLogType)SVNLogType.CLIENT);
        }
    }

    protected void relocate(List targets) throws SVNException {
        if (targets.size() < 1) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        if (targets.size() == 1 || targets.size() == 2 && new SVNPath((String)targets.get(0)).isURL() && !new SVNPath((String)targets.get(1)).isURL()) {
            SVNPath target = targets.size() == 2 ? new SVNPath((String)targets.get(1)) : new SVNPath("");
            SVNPath to = new SVNPath((String)targets.get(0));
            client.doRelocate(target.getFile(), null, to.getURL(), this.getSVNEnvironment().getDepth().isRecursive());
        } else {
            if (targets.get(0).equals(targets.get(1))) {
                return;
            }
            SVNPath from = new SVNPath((String)targets.get(0));
            SVNPath to = new SVNPath((String)targets.get(1));
            if (from.isURL() != to.isURL() || !from.isURL()) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.INCORRECT_PARAMS, (String)"''{0}'' to ''{1}'' is not a valid relocation", (Object[])new Object[]{from.getTarget(), to.getTarget()});
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if (targets.size() == 2) {
                SVNPath target = new SVNPath("");
                client.doRelocate(target.getFile(), from.getURL(), to.getURL(), this.getSVNEnvironment().getDepth().isRecursive());
            } else {
                for (int i = 2; i < targets.size(); ++i) {
                    SVNPath target = new SVNPath((String)targets.get(i));
                    client.doRelocate(target.getFile(), from.getURL(), to.getURL(), this.getSVNEnvironment().getDepth().isRecursive());
                }
            }
        }
    }
}

