/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;

public class SVNLookDateCommand
extends SVNLookCommand {
    protected SVNLookDateCommand() {
        super("date", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNProperties props = this.getProperties();
        SVNPropertyValue value = props.getSVNPropertyValue("svn:date");
        if (value != null && value.getString() != null) {
            SVNDate date = SVNDate.parseDate((String)value.getString());
            this.getEnvironment().getOut().print(SVNDate.formatHumanDate((Date)date, null));
        }
        this.getEnvironment().getOut().println();
    }
}

