/*
 * Decompiled with CFR 0.152.
 */
package de.renew.svn;

import java.io.File;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNUtil {
    private static Logger logger = Logger.getLogger(SVNUtil.class);
    private static SVNClientManager svnManager;
    private static SVNLogClient logClient;
    private static SVNWCClient wcClient;
    private static SVNUtil instance;

    public static SVNUtil getInstance() {
        if (instance == null) {
            instance = new SVNUtil();
        }
        return instance;
    }

    private SVNUtil() {
        DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions((boolean)true);
        svnManager = SVNClientManager.newInstance((ISVNOptions)defaultSVNOptions);
        logClient = svnManager.getLogClient();
        wcClient = svnManager.getWCClient();
    }

    public boolean displayLog(File file) {
        boolean bl;
        block2: {
            bl = false;
            ISVNLogEntryHandler iSVNLogEntryHandler = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry sVNLogEntry) throws SVNException {
                    System.out.println(sVNLogEntry.getAuthor());
                    System.out.println(sVNLogEntry.getMessage());
                }
            };
            try {
                logClient.doLog(new File[]{file}, SVNRevision.HEAD, SVNRevision.create((long)1000L), SVNRevision.HEAD, false, false, false, 20L, new String[0], iSVNLogEntryHandler);
            }
            catch (SVNException sVNException) {
                logger.error((Object)sVNException.getMessage());
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)(SVNUtil.class.getSimpleName() + ": " + sVNException));
            }
        }
        return bl;
    }

    public boolean displayInfo(File file) {
        SVNInfo sVNInfo;
        boolean bl;
        block3: {
            bl = false;
            sVNInfo = null;
            try {
                sVNInfo = wcClient.doInfo(file, SVNRevision.BASE);
                bl = true;
            }
            catch (SVNException sVNException) {
                logger.error((Object)sVNException.getMessage());
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)(SVNUtil.class.getSimpleName() + ": " + sVNException));
            }
        }
        if (sVNInfo != null) {
            System.out.println("SvnInfo for file: " + file.getName() + " " + sVNInfo.getRevision() + " " + sVNInfo.getAuthor() + " " + sVNInfo.getCommittedDate());
        }
        return bl;
    }
}

