/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.xml;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.xml.InscriptionTypeSource;
import de.renew.gui.xml.OrderedFigureEnumeration;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class XRNCreator {
    public static Logger logger = Logger.getLogger(XRNCreator.class);

    private static void writePoint(PrintWriter printWriter, String string, Point point, String string2) {
        printWriter.println(string2 + "<" + string + " x=\"" + String.valueOf(point.x) + "\" y=\"" + String.valueOf(point.y) + "\"/>");
    }

    private static void writeColor(PrintWriter printWriter, String string, Object object, String string2) {
        if (object instanceof Color) {
            Color color = (Color)object;
            if (ColorMap.isTransparent((Color)color)) {
                printWriter.println(string2 + "<" + string + "><transparent/></" + string + ">");
            } else if (ColorMap.isBackground((Color)color)) {
                printWriter.println(string2 + "<" + string + "><background/></" + string + ">");
            } else {
                printWriter.println(string2 + "<" + string + "><RGBcolor r=\"" + color.getRed() + "\" g=\"" + color.getGreen() + "\" b=\"" + color.getBlue() + "\"/></" + string + ">");
            }
        }
    }

    private static String quoteText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void writeSimpleElement(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println(string3 + "<" + string + ">" + XRNCreator.quoteText(string2) + "</" + string + ">");
    }

    private static void writeGraphics(PrintWriter printWriter, Figure figure, String string) {
        Object object;
        String string2 = string + "  ";
        printWriter.println(string + "<graphics>");
        if (!(figure instanceof LineConnection)) {
            object = figure.size();
            printWriter.println(string2 + "<size w=\"" + ((Dimension)object).width + "\" h=\"" + ((Dimension)object).height + "\"/>");
        }
        if (figure instanceof TextFigure && (object = ((TextFigure)figure).getAttribute("FontSize")) instanceof Integer) {
            printWriter.println(string2 + "<textsize size=\"" + object + "\"/>");
        }
        if (!(figure instanceof LineConnection)) {
            object = null;
            if (figure instanceof ChildFigure) {
                object = ((ChildFigure)figure).parent();
            }
            Point point = new Point(0, 0);
            if (object != null) {
                point = object.center();
            }
            Point point2 = figure.center();
            point2.translate(-point.x, -point.y);
            XRNCreator.writePoint(printWriter, "offset", point2, string2);
        }
        if (figure instanceof AttributeFigure) {
            object = (AttributeFigure)figure;
            XRNCreator.writeColor(printWriter, "fillcolor", object.getAttribute("FillColor"), string2);
            XRNCreator.writeColor(printWriter, "pencolor", object.getAttribute("FrameColor"), string2);
            XRNCreator.writeColor(printWriter, "textcolor", object.getAttribute("TextColor"), string2);
        }
        if (figure instanceof LineConnection) {
            object = (LineConnection)figure;
            int n = object.pointCount();
            boolean bl = XRNCreator.isInverted((LineConnection)object);
            for (int i = 1; i < n - 1; ++i) {
                Point point = object.pointAt(bl ? n - i - 1 : i);
                XRNCreator.writePoint(printWriter, "point", point, string2);
            }
        }
        printWriter.println(string + "</graphics>");
    }

    private static void writeAllChildren(PrintWriter printWriter, Figure figure, String string, InscriptionTypeSource inscriptionTypeSource) {
        if (figure instanceof ParentFigure) {
            ParentFigure parentFigure = (ParentFigure)figure;
            parentFigure.center();
            OrderedFigureEnumeration orderedFigureEnumeration = new OrderedFigureEnumeration((Enumeration<Figure>)parentFigure.children());
            while (orderedFigureEnumeration.hasMoreElements()) {
                Figure figure2 = orderedFigureEnumeration.nextFigure();
                if (!(figure2 instanceof CPNTextFigure)) continue;
                CPNTextFigure cPNTextFigure = (CPNTextFigure)figure2;
                printWriter.println(string + "<annotation" + XRNCreator.determineAttributes((Figure)cPNTextFigure, inscriptionTypeSource) + ">");
                XRNCreator.writeSimpleElement(printWriter, "text", cPNTextFigure.getText(), string + "  ");
                XRNCreator.writeGraphics(printWriter, (Figure)cPNTextFigure, string + "  ");
                printWriter.println(string + "</annotation>");
            }
        }
    }

    private static boolean isInverted(LineConnection lineConnection) {
        Integer n = (Integer)lineConnection.getAttribute("ArrowMode");
        return new Integer(1).equals(n);
    }

    private static String determineAttributes(Figure figure, InscriptionTypeSource inscriptionTypeSource) {
        StringBuffer stringBuffer = new StringBuffer(" id=\"I");
        stringBuffer.append(((FigureWithID)figure).getID());
        stringBuffer.append("\"");
        if (figure instanceof LineConnection) {
            LineConnection lineConnection = (LineConnection)figure;
            FigureWithID figureWithID = (FigureWithID)lineConnection.start().owner();
            FigureWithID figureWithID2 = (FigureWithID)lineConnection.end().owner();
            if (XRNCreator.isInverted(lineConnection)) {
                FigureWithID figureWithID3 = figureWithID;
                figureWithID = figureWithID2;
                figureWithID2 = figureWithID3;
            }
            stringBuffer.append(" source=\"I" + figureWithID.getID() + "\" target=\"I" + figureWithID2.getID() + "\"");
            if (figure instanceof ArcConnection) {
                stringBuffer.append(" type=\"");
                switch (((ArcConnection)lineConnection).getArcType()) {
                    case 2: {
                        stringBuffer.append("double");
                        break;
                    }
                    case 0: {
                        stringBuffer.append("test");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("inhibitor");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("multi-ordinary");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("clear");
                        break;
                    }
                    default: {
                        stringBuffer.append("ordinary");
                    }
                }
                stringBuffer.append("\"");
            }
        } else if (figure instanceof CPNTextFigure) {
            String string;
            CPNTextFigure cPNTextFigure = (CPNTextFigure)figure;
            if (cPNTextFigure.getType() == 0) {
                stringBuffer.append(" type=\"comment\"");
            } else if (cPNTextFigure.getType() == 2) {
                stringBuffer.append(" type=\"name\"");
            } else if (inscriptionTypeSource != null && (string = inscriptionTypeSource.getType(cPNTextFigure.getText(), cPNTextFigure.getType() == 3)) != null) {
                stringBuffer.append(" type=\"" + string + "\"");
            }
        }
        return stringBuffer.toString();
    }

    private static void writeAll(Class<?> clazz, String string, PrintWriter printWriter, CPNDrawing cPNDrawing, InscriptionTypeSource inscriptionTypeSource, InscriptionTypeSource inscriptionTypeSource2) {
        OrderedFigureEnumeration orderedFigureEnumeration = new OrderedFigureEnumeration((Enumeration<Figure>)cPNDrawing.figures());
        while (orderedFigureEnumeration.hasMoreElements()) {
            Figure figure = orderedFigureEnumeration.nextFigure();
            if (!clazz.isInstance(figure) || figure instanceof ChildFigure && ((ChildFigure)figure).parent() != null) continue;
            String string2 = XRNCreator.determineAttributes(figure, inscriptionTypeSource);
            printWriter.println("  <" + string + string2 + ">");
            if (figure instanceof TextFigure) {
                XRNCreator.writeSimpleElement(printWriter, "text", ((TextFigure)figure).getText(), "    ");
            }
            XRNCreator.writeGraphics(printWriter, figure, "    ");
            XRNCreator.writeAllChildren(printWriter, figure, "    ", inscriptionTypeSource2);
            printWriter.println("  </" + string + ">");
        }
    }

    public static void write(OutputStream outputStream, CPNDrawing cPNDrawing, ShadowCompilerFactory shadowCompilerFactory) {
        XRNCreator.write(new PrintWriter(outputStream), cPNDrawing, shadowCompilerFactory);
    }

    public static void write(Writer writer, CPNDrawing cPNDrawing, ShadowCompilerFactory shadowCompilerFactory) {
        XRNCreator.write(new PrintWriter(writer), cPNDrawing, shadowCompilerFactory);
    }

    public static void write(PrintWriter printWriter, CPNDrawing cPNDrawing, ShadowCompilerFactory shadowCompilerFactory) {
        try {
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<!DOCTYPE net SYSTEM \"http://www.informatik.uni-hamburg.de/TGI/renew/xrn1.dtd\">");
            printWriter.println("<net id=\"N\" type=\"hlnet\">");
            XRNCreator.writeAll(PlaceFigure.class, "place", printWriter, cPNDrawing, null, new InscriptionTypeSource(shadowCompilerFactory){

                @Override
                public String calculateType(String string, boolean bl, ShadowNet shadowNet) throws Exception {
                    return shadowNet.checkPlaceInscription(string, bl);
                }
            });
            XRNCreator.writeAll(TransitionFigure.class, "transition", printWriter, cPNDrawing, null, new InscriptionTypeSource(shadowCompilerFactory){

                @Override
                public String calculateType(String string, boolean bl, ShadowNet shadowNet) throws Exception {
                    return shadowNet.checkTransitionInscription(string, bl);
                }
            });
            XRNCreator.writeAll(ArcConnection.class, "arc", printWriter, cPNDrawing, null, new InscriptionTypeSource(shadowCompilerFactory){

                @Override
                public String calculateType(String string, boolean bl, ShadowNet shadowNet) throws Exception {
                    return shadowNet.checkArcInscription(string, bl);
                }
            });
            printWriter.println("  <annotation id=\"A1\" type=\"name\">");
            XRNCreator.writeSimpleElement(printWriter, "text", cPNDrawing.getName(), "    ");
            printWriter.println("  </annotation>");
            XRNCreator.writeAll(CPNTextFigure.class, "annotation", printWriter, cPNDrawing, new InscriptionTypeSource(shadowCompilerFactory){

                @Override
                public String calculateType(String string, boolean bl, ShadowNet shadowNet) throws Exception {
                    return shadowNet.checkDeclarationNode(string, bl);
                }
            }, null);
            printWriter.println("</net>");
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        printWriter.flush();
    }
}

