/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.io.exportFormats.LolaExportFormat;
import de.renew.io.importFormats.LolaImportFormat;
import de.renew.lola.commands.CheckAllCommand;
import de.renew.lola.commands.CheckAllTasksCommand;
import de.renew.lola.commands.CheckLivenessCommand;
import de.renew.lola.commands.CheckSelectedPlaceCommand;
import de.renew.lola.commands.CheckSelectedTransitionCommand;
import de.renew.lola.commands.CheckVerificationRequestCommand;
import de.renew.lola.commands.OpenLolaGUICommand;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class LolaPlugin
extends PluginAdapter {
    private CommandMenu _menu;
    private static StringBuffer lolaPath = new StringBuffer();
    private static Logger logger = Logger.getLogger(LolaPlugin.class);

    public LolaPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public LolaPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public boolean cleanup() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin == null) {
            return true;
        }
        MenuManager menuManager = drawPlugin.getMenuManager();
        if (menuManager != null && this._menu != null) {
            menuManager.unregisterMenu((JMenuItem)this._menu);
        }
        return true;
    }

    public String getAlias() {
        return "lola";
    }

    public void init() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        ExportHolder exportHolder = DrawPlugin.getCurrent().getExportHolder();
        exportHolder.addExportFormat((ExportFormat)new LolaExportFormat());
        ImportHolder importHolder = DrawPlugin.getCurrent().getImportHolder();
        importHolder.addImportFormat((ImportFormat)new LolaImportFormat());
        if (drawPlugin == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] Plugin Name: " + this._properties.getName()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] Plugin Location: " + this._properties.getURL()));
        }
        String string = this._properties.getURL().getPath();
        try {
            string = URLDecoder.decode(this._properties.getURL().getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.warn((Object)"[Lola] could not decode location of Lola plugin.");
        }
        String string2 = System.getProperty("file.separator");
        lolaPath.append(string.substring(0, string.lastIndexOf("/")).replace("%20", " "));
        lolaPath.append(string2 + "lib" + string2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] computed lib path: " + lolaPath.toString()));
        }
        MenuManager menuManager = drawPlugin.getMenuManager();
        this._menu = new CommandMenu("Lola Integration");
        this._menu.add((Command)new OpenLolaGUICommand("Show Lola GUI", lolaPath.toString()), 56);
        this._menu.add((Command)new CheckAllTasksCommand("Check all verification tasks"));
        this._menu.add((Command)new CheckVerificationRequestCommand("Check selected request", lolaPath.toString()), 52);
        this._menu.add((Command)new CheckSelectedTransitionCommand("Check selected Transitions", lolaPath.toString()));
        this._menu.add((Command)new CheckSelectedPlaceCommand("Check selected Places", lolaPath.toString()));
        this._menu.add((Command)new CheckAllCommand("Check all places and transitions", lolaPath.toString()));
        this._menu.add((Command)new CheckLivenessCommand("Check liveness", lolaPath.toString()));
        this._menu.add((Command)new VersionInfoCommand((IPlugin)this));
        this._menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.lola");
        menuManager.registerMenu("Tools", (JMenuItem)this._menu);
    }

    public static String getLolaPath() {
        return lolaPath.toString();
    }

    public static LolaPlugin getCurrent() {
        for (Object e : PluginManager.getInstance().getPluginsProviding("de.renew.lola")) {
            if (!(e instanceof LolaPlugin)) continue;
            return (LolaPlugin)((Object)e);
        }
        return null;
    }
}

