/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola.LolaAnalyzer;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaResult;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class CheckAllCommand
extends Command
implements CLCommand {
    private String lolaPath;
    private static Logger logger = Logger.getLogger(CheckAllCommand.class);

    public CheckAllCommand(String string, String string2) {
        super(string);
        this.lolaPath = string2;
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        CPNDrawing cPNDrawing = (CPNDrawing)drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawApplication.drawing());
        FigureEnumeration figureEnumeration = drawApplication.drawing().figures();
        LolaAnalyzer lolaAnalyzer = new LolaAnalyzer(this.lolaPath);
        File file = LolaFileCreator.writeTemporaryLolaFile(cPNDrawing);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + file.getPath()));
        }
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            LolaResult lolaResult = null;
            if (figure instanceof PlaceFigure) {
                if (figure instanceof VirtualPlaceFigure) continue;
                lolaResult = lolaAnalyzer.checkPlace((PlaceFigure)figure, file);
            }
            if (figure instanceof TransitionFigure) {
                lolaResult = lolaAnalyzer.checkTransition((TransitionFigure)figure, file);
            }
            if (lolaResult == null) continue;
            int n = lolaResult.getExitValue();
            switch (n) {
                case 0: {
                    if (figure instanceof TransitionFigure) {
                        lolaAnalyzer.colorFigure(figure, Color.GREEN);
                        break;
                    }
                    if (!(figure instanceof PlaceFigure)) break;
                    lolaAnalyzer.colorFigure(figure, Color.RED);
                    break;
                }
                case 1: {
                    if (figure instanceof TransitionFigure) {
                        lolaAnalyzer.colorFigure(figure, Color.RED);
                        break;
                    }
                    if (!(figure instanceof PlaceFigure)) break;
                    lolaAnalyzer.colorFigure(figure, Color.GREEN);
                    break;
                }
            }
        }
        drawApplication.getUndoRedoManager().commitUndoSnapshot(drawApplication.drawing());
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return "Check all places and transitions.";
    }
}

