/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.net.TimeSetResult;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class TimeSet
implements Serializable {
    public static final TimeSet EMPTY = new TimeSet(null, 0.0, 0, null);
    public static final TimeSet ZERO = EMPTY.including(0.0);
    private TimeSet left;
    private double time;
    private TimeSet right;
    private int mult;
    private int height;
    private int size;
    private int uniqueSize;

    private TimeSet(TimeSet timeSet, double d, int n, TimeSet timeSet2) {
        if (n == 0) {
            if (timeSet != null || timeSet2 != null || d != 0.0) {
                throw new RuntimeException("Bad empty time set parameters.");
            }
            this.left = null;
            this.right = null;
            this.mult = 0;
            this.time = 0.0;
            this.height = 0;
            this.size = 0;
            this.uniqueSize = 0;
        } else {
            int n2 = timeSet.height;
            int n3 = timeSet2.height;
            int n4 = n2 - n3;
            if (n4 >= 2) {
                int n5 = timeSet.left.height;
                int n6 = timeSet.right.height;
                if (n5 > n6) {
                    this.left = timeSet.left;
                    this.time = timeSet.time;
                    this.mult = timeSet.mult;
                    this.right = new TimeSet(timeSet.right, d, n, timeSet2);
                } else {
                    this.left = new TimeSet(timeSet.left, timeSet.time, timeSet.mult, timeSet.right.left);
                    this.time = timeSet.right.time;
                    this.mult = timeSet.right.mult;
                    this.right = new TimeSet(timeSet.right.right, d, n, timeSet2);
                }
            } else if (n4 <= -2) {
                int n7 = timeSet2.right.height;
                int n8 = timeSet2.left.height;
                if (n7 > n8) {
                    this.left = new TimeSet(timeSet, d, n, timeSet2.left);
                    this.time = timeSet2.time;
                    this.mult = timeSet2.mult;
                    this.right = timeSet2.right;
                } else {
                    this.left = new TimeSet(timeSet, d, n, timeSet2.left.left);
                    this.time = timeSet2.left.time;
                    this.mult = timeSet2.left.mult;
                    this.right = new TimeSet(timeSet2.left.right, timeSet2.time, timeSet2.mult, timeSet2.right);
                }
            } else {
                this.left = timeSet;
                this.time = d;
                this.mult = n;
                this.right = timeSet2;
            }
            this.height = Math.max(timeSet.height, timeSet2.height) + 1;
            this.size = timeSet.size + timeSet2.size + n;
            this.uniqueSize = timeSet.uniqueSize + timeSet2.uniqueSize + 1;
        }
    }

    public boolean isEmpty() {
        return this.mult == 0;
    }

    public static TimeSet make(double d, int n) {
        return new TimeSet(EMPTY, d, n, EMPTY);
    }

    public int getSize() {
        return this.size;
    }

    private TimeSet findNode(double d) {
        TimeSet timeSet = this;
        while (timeSet.mult != 0) {
            if (timeSet.time == d) {
                return timeSet;
            }
            if (timeSet.time < d) {
                timeSet = timeSet.right;
                continue;
            }
            timeSet = timeSet.left;
        }
        return EMPTY;
    }

    public int multiplicity(double d) {
        return this.findNode((double)d).mult;
    }

    public TimeSet including(double d) {
        return this.including(d, 1);
    }

    public TimeSet including(double d, int n) {
        TimeSet timeSet;
        TimeSet timeSet2;
        if (this.mult == 0) {
            return TimeSet.make(d, n);
        }
        if (d == this.time) {
            return new TimeSet(this.left, this.time, this.mult + n, this.right);
        }
        if (d < this.time) {
            timeSet2 = this.left.including(d, n);
            timeSet = this.right;
        } else {
            timeSet2 = this.left;
            timeSet = this.right.including(d, n);
        }
        return new TimeSet(timeSet2, this.time, this.mult, timeSet);
    }

    public TimeSet excluding(double d) {
        int n;
        double d2;
        TimeSet timeSet;
        TimeSet timeSet2;
        if (this.mult == 0) {
            throw new NoSuchElementException();
        }
        if (d == this.time) {
            if (this.mult > 1) {
                timeSet2 = this.left;
                timeSet = this.right;
                d2 = this.time;
                n = this.mult - 1;
            } else {
                if (this.right.mult == 0) {
                    return this.left;
                }
                if (this.left.mult == 0) {
                    return this.right;
                }
                TimeSetResult timeSetResult = this.right.extractLeftmost();
                timeSet2 = this.left;
                timeSet = timeSetResult.tree;
                d2 = timeSetResult.time;
                n = timeSetResult.mult;
            }
        } else {
            if (d < this.time) {
                timeSet2 = this.left.excluding(d);
                timeSet = this.right;
            } else {
                timeSet2 = this.left;
                timeSet = this.right.excluding(d);
            }
            d2 = this.time;
            n = this.mult;
        }
        return new TimeSet(timeSet2, d2, n, timeSet);
    }

    private TimeSetResult extractLeftmost() {
        if (this.mult == 0) {
            throw new RuntimeException("Illegal invocation of extractLeftmost().");
        }
        if (this.left.mult == 0) {
            return new TimeSetResult(this.right, this.time, this.mult);
        }
        TimeSetResult timeSetResult = this.left.extractLeftmost();
        return new TimeSetResult(new TimeSet(timeSetResult.tree, this.time, this.mult, this.right), timeSetResult.time, timeSetResult.mult);
    }

    public double earliestTime() {
        TimeSet timeSet = this;
        while (timeSet.left.mult != 0) {
            timeSet = timeSet.left;
        }
        return timeSet.time;
    }

    public double latestTime() throws NoSuchElementException {
        TimeSet timeSet = this;
        if (this.mult == 0) {
            throw new NoSuchElementException();
        }
        while (timeSet.right.mult != 0) {
            timeSet = timeSet.right;
        }
        return timeSet.time;
    }

    public double latestWithDelay(double d, double d2) {
        TimeSet timeSet = this;
        TimeSet timeSet2 = null;
        while (timeSet.mult != 0) {
            if (timeSet.time + d <= d2) {
                timeSet2 = timeSet;
                timeSet = timeSet.right;
                continue;
            }
            timeSet = timeSet.left;
        }
        if (timeSet2 != null) {
            return timeSet2.time;
        }
        throw new NoSuchElementException();
    }

    public double[] asUniqueArray() {
        double[] dArray = new double[this.uniqueSize];
        this.fillIn(dArray, 0, true);
        return dArray;
    }

    public double[] asArray() {
        double[] dArray = new double[this.size];
        this.fillIn(dArray, 0, false);
        return dArray;
    }

    private void fillIn(double[] dArray, int n, boolean bl) {
        if (this.mult == 0) {
            return;
        }
        this.left.fillIn(dArray, n, bl);
        if (bl) {
            n += this.left.uniqueSize;
            dArray[n++] = this.time;
        } else {
            n += this.left.size;
            for (int i = 0; i < this.mult; ++i) {
                dArray[n++] = this.time;
            }
        }
        this.right.fillIn(dArray, n, bl);
    }

    public double computeEarliestTime(TimeSet timeSet) {
        return this.computeEarliestTime(timeSet.asArray());
    }

    public double computeEarliestTime(double[] dArray) {
        if (dArray.length > this.size) {
            return Double.POSITIVE_INFINITY;
        }
        return this.computeEarliestTime(dArray, dArray.length - 1);
    }

    private double computeEarliestTime(double[] dArray, int n) {
        double d = Double.NEGATIVE_INFINITY;
        if (this.mult > 0) {
            d = this.left.computeEarliestTime(dArray, n);
            if ((n -= this.left.size) >= 0) {
                d = Math.max(d, this.time + dArray[n]);
                if ((n -= this.mult) >= 0) {
                    d = Math.max(d, this.right.computeEarliestTime(dArray, n));
                }
            }
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimeSet(");
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer) {
        if (this.mult == 0) {
            return;
        }
        this.left.toString(stringBuffer);
        for (int i = 0; i < this.mult; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(this.time);
        }
        this.right.toString(stringBuffer);
    }
}

