/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searcher.DeltaSet;
import de.renew.engine.searcher.DeltaSetFactory;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReservation;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class TokenReserver
implements DeltaSet {
    private static final Factory FACTORY = new Factory();
    Hashtable<SimulatablePlaceInstance, TokenReservation> reservations = new Hashtable();

    public static TokenReserver getInstance(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return (TokenReserver)searcher.getDeltaSet(FACTORY);
    }

    TokenReserver() {
    }

    public void reset() {
        this.reservations = new Hashtable();
    }

    @Override
    public double computeEarliestTime() {
        double d = 0.0;
        Enumeration<TokenReservation> enumeration = this.reservations.elements();
        while (enumeration.hasMoreElements()) {
            TokenReservation tokenReservation = enumeration.nextElement();
            double d2 = tokenReservation.computeEarliestTime();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private TokenReservation getReservation(SimulatablePlaceInstance simulatablePlaceInstance) {
        if (this.reservations.containsKey(simulatablePlaceInstance)) {
            return this.reservations.get(simulatablePlaceInstance);
        }
        TokenReservation tokenReservation = new TokenReservation(simulatablePlaceInstance);
        this.reservations.put(simulatablePlaceInstance, tokenReservation);
        return tokenReservation;
    }

    private void disposeReservation(PlaceInstance placeInstance) {
        TokenReservation tokenReservation = this.reservations.get(placeInstance);
        if (tokenReservation.isRemovable()) {
            this.reservations.remove(placeInstance);
        }
    }

    public synchronized boolean containsRemovableToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object, double d) {
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        boolean bl = tokenReservation.containsRemovableToken(object, d);
        this.disposeReservation(simulatablePlaceInstance);
        return bl;
    }

    public synchronized boolean containsTestableToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        boolean bl = tokenReservation.containsTestableToken(object);
        this.disposeReservation(simulatablePlaceInstance);
        return bl;
    }

    public synchronized boolean removeToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        boolean bl = tokenReservation.removeToken(object, d);
        this.disposeReservation(simulatablePlaceInstance);
        return bl;
    }

    public synchronized boolean testToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        boolean bl = tokenReservation.testToken(object);
        this.disposeReservation(simulatablePlaceInstance);
        return bl;
    }

    public synchronized void unremoveToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        tokenReservation.unremoveToken(object, d);
        this.disposeReservation(simulatablePlaceInstance);
    }

    public synchronized void untestToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        tokenReservation.untestToken(object);
        this.disposeReservation(simulatablePlaceInstance);
    }

    public synchronized Collection<Object> getRemovableTokens(SimulatablePlaceInstance simulatablePlaceInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        Collection<Object> collection = tokenReservation.getRemovableTokens(object);
        this.disposeReservation(simulatablePlaceInstance);
        return collection;
    }

    public synchronized Collection<Object> getTestableTokens(SimulatablePlaceInstance simulatablePlaceInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(simulatablePlaceInstance);
        Collection<Object> collection = tokenReservation.getTestableTokens(object);
        this.disposeReservation(simulatablePlaceInstance);
        return collection;
    }

    private static class Factory
    implements DeltaSetFactory {
        private Factory() {
        }

        @Override
        public String getCategory() {
            return "de.renew.nets.TokenReserver";
        }

        @Override
        public DeltaSet createDeltaSet() {
            return new TokenReserver();
        }
    }
}

