/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.NoGuiAvailableException;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.InfoDialog;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import CH.ifa.draw.util.StorableInput;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.gui.AggregateFigureCreator;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNApplication;
import de.renew.gui.ConfigureEngineController;
import de.renew.gui.ConfigureNetpathController;
import de.renew.gui.ConfigureRemoteAccessController;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.Demonstrator;
import de.renew.gui.FigureCreator;
import de.renew.gui.FigureCreatorComposition;
import de.renew.gui.FigureCreatorHolder;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPalettes;
import de.renew.gui.LocalFigureFigureCreator;
import de.renew.gui.ModeReplacement;
import de.renew.gui.NetInstanceFigureCreator;
import de.renew.gui.NetMenuCreator;
import de.renew.gui.PaletteHolder;
import de.renew.gui.PatchingStorableInput;
import de.renew.gui.SimulationMenuCreator;
import de.renew.gui.StartGuiCommand;
import de.renew.gui.SyntaxExceptionFrame;
import de.renew.gui.TextFigureCreator;
import de.renew.gui.TokenFigureCreator;
import de.renew.gui.menu.AlignmentMenuExtender;
import de.renew.gui.menu.AttributesMenuExtender;
import de.renew.gui.menu.EditMenuExtender;
import de.renew.gui.menu.HelpMenuCreator;
import de.renew.io.exportFormats.SNSExportFormat;
import de.renew.io.exportFormats.WoflanExportFormat;
import de.renew.io.exportFormats.XMLExportFormat;
import de.renew.io.importFormats.SNSImportFormat;
import de.renew.io.importFormats.XMLImportFormat;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.remote.NetInstanceAccessor;
import de.renew.shadow.SyntaxException;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GuiPlugin
extends PluginAdapter
implements StatusDisplayer {
    public static Logger logger = Logger.getLogger(GuiPlugin.class);
    public static final String MENU_PREFIX = "de.renew.gui";
    public static final String SIMULATION_MENU = "Simulation";
    public static final String NET_MENU = "Net";
    public static final String VERIFICATION_MENU = "Verification";
    private SyntaxExceptionFrame syntaxFrame = null;
    private Collection<String> _menus = new Vector<String>();
    private GuiPalettes paletteManager = new GuiPalettes(this);
    private CPNApplication _gui;
    private FigureCreatorComposition _figureCreator = new FigureCreatorComposition();
    private SimulationStateListener _simulationListener = null;
    private List<ConfigureSimulationTabController> _simConfigTabControllers = new Vector<ConfigureSimulationTabController>();
    public static final String SHUTDOWN_PROP_NAME = "de.renew.gui.shutdownOnClose";
    public static final String AUTOSTART_PROP_NAME = "de.renew.gui.autostart";
    public static final String USE_VERIFICATION_MENU_PROP_NAME = "de.renew.gui.verificationMenu";
    private BreakpointManager bpManager = null;

    public GuiPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public GuiPlugin(PluginProperties pluginProperties) throws PluginException {
        super(pluginProperties);
    }

    public void init() {
        logger.debug((Object)"initializing GUI plugin.");
        GuiPlugin.patchStorableInput();
        this._simulationListener = new SimulationStateListener();
        Collection<JMenuItem> collection = new AlignmentMenuExtender().createMenus();
        Collection<JMenuItem> collection2 = new AttributesMenuExtender().createMenus();
        Collection<JMenuItem> collection3 = new EditMenuExtender().createMenus();
        Collection<JMenuItem> collection4 = new SimulationMenuCreator().createMenus(this.getBreakpointManager());
        Collection<JMenuItem> collection5 = new NetMenuCreator().createMenus(this.getBreakpointManager());
        Collection<JMenuItem> collection6 = new HelpMenuCreator().createMenus();
        this.registerMenuItems(NET_MENU, collection5);
        this.registerMenuItems(SIMULATION_MENU, collection4);
        this.registerMenuItems("Help", collection6);
        this.registerMenuItems("Layout", collection);
        this.registerMenuItems("Attributes", collection2);
        this.registerMenuItems("Edit", collection3);
        this.registerCreators();
        SimulatorPlugin.getCurrent().addExtension((SimulatorExtension)this._simulationListener);
        this.initDefaultImportFormats();
        this.initDefaultExportFormats();
        PluginManager pluginManager = PluginManager.getInstance();
        pluginManager.addCLCommand("gui", (CLCommand)new StartGuiCommand(this));
        pluginManager.addCLCommand("demonstrator", (CLCommand)new Demonstrator());
        if (this.getProperties().getBoolProperty(AUTOSTART_PROP_NAME)) {
            ((StartGuiCommand)pluginManager.getCLCommands().get("gui")).execute(new String[0], System.out);
        }
        this._simConfigTabControllers.add(new ConfigureEngineController());
        this._simConfigTabControllers.add(new ConfigureRemoteAccessController());
        this._simConfigTabControllers.add(new ConfigureNetpathController());
    }

    public static void patchStorableInput() {
        DrawingFileHelper.setStorableInputDrawingLoader((StorableInputDrawingLoader)new StorableInputDrawingLoader(){

            protected StorableInput makeStorableInput(URL uRL, boolean bl) throws IOException {
                return new PatchingStorableInput(uRL, bl);
            }
        });
    }

    private void registerMenuItems(String string, Collection<JMenuItem> collection) {
        Iterator<JMenuItem> iterator = collection.iterator();
        MenuManager menuManager = MenuManager.getInstance();
        while (iterator.hasNext()) {
            JMenuItem jMenuItem = iterator.next();
            JMenuItem jMenuItem2 = null;
            if (jMenuItem instanceof JMenuItem) {
                jMenuItem2 = jMenuItem;
            } else if (jMenuItem instanceof Command) {
                jMenuItem2 = new CommandMenuItem((Command)jMenuItem);
            }
            if (jMenuItem2 != null) {
                String string2 = "de.renew.gui." + jMenuItem2.getText();
                this._menus.add(string2);
                menuManager.registerMenu(string, jMenuItem2, string2);
                continue;
            }
            logger.warn((Object)("GuiPlugin.registerMenuItems: Could not register " + string + ". No parent menu found."));
        }
    }

    public synchronized boolean cleanup() {
        Iterator<String> iterator = this._menus.iterator();
        while (iterator.hasNext()) {
            DrawPlugin.getCurrent().getMenuManager().unregisterMenu(iterator.next());
        }
        if (this.isGuiPresent()) {
            GuiPlugin.doSynchronized(new Runnable(){

                @Override
                public void run() {
                    GuiPlugin.this._gui.exit();
                }
            });
        }
        Demonstrator.cleanup();
        if (this._simulationListener != null) {
            SimulatorPlugin.getCurrent().removeExtension((SimulatorExtension)this._simulationListener);
            this._simulationListener = null;
        }
        PluginManager.getInstance().removeCLCommand("gui");
        PluginManager.getInstance().removeCLCommand("demonstrator");
        return true;
    }

    public synchronized boolean canShutDown() {
        if (this.isGuiPresent()) {
            class GuiQuery
            implements Runnable {
                public boolean exitOK = false;

                GuiQuery() {
                }

                @Override
                public void run() {
                    this.exitOK = GuiPlugin.this._gui.canClose();
                }
            }
            GuiQuery guiQuery = new GuiQuery();
            logger.debug((Object)"asking gui to allow close operation");
            GuiPlugin.doSynchronized(guiQuery);
            return guiQuery.exitOK;
        }
        return true;
    }

    private static void doSynchronized(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("GuiPlugin: synchronised operation has been interrupted.", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("GuiPlugin: synchronised operation has failed.", invocationTargetException.getTargetException());
            }
        }
    }

    public static GuiPlugin getCurrent() {
        for (IPlugin iPlugin : PluginManager.getInstance().getPluginsProviding(MENU_PREFIX)) {
            if (!(iPlugin instanceof GuiPlugin)) continue;
            return (GuiPlugin)iPlugin;
        }
        return null;
    }

    public ConfigureSimulationTabController[] getConfigTabController() {
        return this._simConfigTabControllers.toArray(new ConfigureSimulationTabController[0]);
    }

    public void addConfigTabController(ConfigureSimulationTabController configureSimulationTabController) {
        this._simConfigTabControllers.add(configureSimulationTabController);
    }

    public void removeConfigTabController(ConfigureSimulationTabController configureSimulationTabController) {
        this._simConfigTabControllers.remove(configureSimulationTabController);
    }

    public synchronized void openGui() {
        if (!this.isGuiPresent()) {
            final GuiPlugin guiPlugin = this;
            GuiPlugin.doSynchronized(new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)("GuiPlugin: Starting gui. Classloader is " + String.valueOf(this.getClass().getClassLoader())));
                    new CPNApplication(guiPlugin);
                }
            });
        }
        this.paletteManager.notifyGuiOpen();
        assert (this.isGuiPresent()) : "Gui should run after opening.";
    }

    void notifyGuiStart(CPNApplication cPNApplication) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in the AWT event thread.";
        assert (!this.isGuiPresent()) : "Must be called exactly once.";
        assert (cPNApplication != null) : "Must be called by the gui instance.";
        this.registerExitBlock();
        this._gui = cPNApplication;
    }

    boolean isShutdownOnClose() {
        return this.getProperties().getBoolProperty(SHUTDOWN_PROP_NAME);
    }

    void doShutdownOnClose() {
        PluginManager.getInstance().stop();
    }

    void notifyGuiClosed(CPNApplication cPNApplication) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in the AWT event thread.";
        assert (this._gui == cPNApplication) : "Must be called by the current gui instance";
        this._gui = null;
        this.registerExitOk();
        ModeReplacement.killInstance();
    }

    public synchronized void closeGui() {
        if (this.isGuiPresent()) {
            GuiPlugin.doSynchronized(new Runnable(){

                @Override
                public void run() {
                    GuiPlugin.this._gui.requestClose();
                }
            });
        }
        this.bpManager = null;
    }

    public CPNApplication getGui() {
        return this._gui;
    }

    public DrawingEditor getDrawingEditor() {
        Object object = null;
        CPNApplication cPNApplication = GuiPlugin.getCurrentGui();
        object = cPNApplication == null ? NullDrawingEditor.INSTANCE : cPNApplication;
        return object;
    }

    public boolean isGuiPresent() {
        return this._gui != null;
    }

    public JFrame getGuiFrame() {
        CPNApplication cPNApplication = this.getGui();
        if (cPNApplication != null) {
            return cPNApplication.getFrame();
        }
        logger.error((Object)"GuiPlugin: no gui to get frame!");
        return null;
    }

    private static CPNApplication getCurrentGui() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            logger.error((Object)"GuiPlugin: no GuiPlugin available.");
            return null;
        }
        return guiPlugin._gui;
    }

    public PaletteHolder getPaletteHolder() {
        return this.paletteManager;
    }

    @Deprecated
    public Drawing openDrawing(Drawing drawing) {
        if (this.isGuiPresent()) {
            return this._gui.openDrawing(drawing);
        }
        throw new NoGuiAvailableException("Cannot create new drawing: no gui window.");
    }

    public synchronized void openInstanceDrawing(final NetInstanceAccessor netInstanceAccessor) throws NoGuiAvailableException {
        if (netInstanceAccessor == null) {
            throw new NullPointerException("Net instance may not be null.");
        }
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("GuiPlugin: no gui to open net instance!");
        }
        GuiPlugin.doSynchronized(new Runnable(){

            @Override
            public void run() {
                GuiPlugin.this.getGui().openInstanceDrawing(netInstanceAccessor);
            }
        });
    }

    public void showStatus(final String string) throws NoGuiAvailableException {
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("GuiPlugin: cannot show status: no gui window.");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CPNApplication cPNApplication = GuiPlugin.getCurrentGui();
                if (cPNApplication != null) {
                    cPNApplication.showStatus(string);
                }
            }
        });
    }

    public InfoDialog createAboutBox() {
        JFrame jFrame = null;
        if (this.isGuiPresent()) {
            jFrame = this.getGui().getFrame();
        }
        PluginProperties pluginProperties = GuiPlugin.getCurrent().getProperties();
        String string = this.getAboutProperty(pluginProperties, "title");
        String string2 = this.getAboutProperty(pluginProperties, "version");
        String string3 = this.getAboutProperty(pluginProperties, "content");
        String string4 = this.getAboutProperty(pluginProperties, "revision");
        String string5 = this.getAboutProperty(pluginProperties, "enableLinks");
        int n = 0;
        if (string4 != null) {
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn((Object)("Revision has wrong format: " + string4), (Throwable)numberFormatException);
            }
        }
        String string6 = string2 + string3 + (String)(n > 0 ? "\nRevision" + n : "");
        boolean bl = false;
        if (string5 != null) {
            bl = Boolean.valueOf(string5);
        }
        return new InfoDialog(jFrame, string, string6, bl);
    }

    private String getAboutProperty(PluginProperties pluginProperties, String string) {
        return pluginProperties.getProperty("de.renew.help." + string, pluginProperties.getProperty("de.renew.help.gui." + string));
    }

    public void bringMenuFrameToFront() {
        if (this.isGuiPresent()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame jFrame = GuiPlugin.this.getGui().getFrame();
                    if (jFrame != null) {
                        jFrame.setVisible(true);
                        jFrame.toFront();
                    }
                }
            });
        }
    }

    public DrawingView getView(Drawing drawing) {
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("GuiPlugin: no view for " + String.valueOf(drawing) + ", no gui window open");
        }
        return this._gui.getView(drawing);
    }

    public void handleSyntaxException(SyntaxException syntaxException) {
        if (this.isGuiPresent()) {
            logger.debug((Object)syntaxException.getMessage(), (Throwable)syntaxException);
            this.processSyntaxException(FigureExceptionFactory.createFigureException(syntaxException), true);
        } else {
            logger.error((Object)syntaxException.getMessage(), (Throwable)syntaxException);
        }
    }

    void processFigureException(FigureException figureException, boolean bl) {
        CPNApplication cPNApplication;
        if (this.syntaxFrame == null && (cPNApplication = this.getGui()) != null) {
            this.syntaxFrame = new SyntaxExceptionFrame(cPNApplication);
        }
        if (this.syntaxFrame != null) {
            this.syntaxFrame.displayException(figureException, bl);
        } else {
            logger.error((Object)figureException.getMessage());
        }
    }

    public void processSyntaxException(FigureException figureException, boolean bl) {
        this.processFigureException(figureException, bl);
        this.showStatus("A syntax error occurred.");
    }

    public void closeSyntaxErrorFrame() {
        if (this.syntaxFrame != null) {
            this.syntaxFrame.dispose();
            this.syntaxFrame = null;
        }
    }

    private void registerCreators() {
        this.safeRegisterFigureCreator("de.renew.gui.Token", new TokenFigureCreator());
        this.safeRegisterFigureCreator("de.renew.unify.Aggregate", new AggregateFigureCreator());
        this.safeRegisterFigureCreator("de.renew.remote.NetInstanceAccessor", new NetInstanceFigureCreator());
        this.safeRegisterFigureCreator("CH.ifa.draw.framework.Figure", new LocalFigureFigureCreator());
    }

    private void safeRegisterFigureCreator(String string, FigureCreator figureCreator) {
        try {
            Class.forName(string, true, PluginManager.getInstance().getBottomClassLoader());
            this._figureCreator.registerCreator(figureCreator);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)("could not register FigureCreator: " + String.valueOf(classNotFoundException)));
        }
    }

    public FigureCreatorHolder getFigureCreatorHolder() {
        return this._figureCreator;
    }

    public TextFigureCreator getTextFigureCreator() {
        return this._figureCreator;
    }

    public FigureCreator getFigureCreator() {
        return this._figureCreator;
    }

    private void initDefaultImportFormats() {
        ImportHolder importHolder = DrawPlugin.getCurrent().getImportHolder();
        importHolder.addImportFormat((ImportFormat)new SNSImportFormat());
        importHolder.addImportFormat((ImportFormat)new XMLImportFormat());
    }

    private void initDefaultExportFormats() {
        ExportHolder exportHolder = DrawPlugin.getCurrent().getExportHolder();
        exportHolder.addExportFormat((ExportFormat)new XMLExportFormat());
        exportHolder.addExportFormat((ExportFormat)new SNSExportFormat());
        exportHolder.addExportFormat((ExportFormat)new WoflanExportFormat());
    }

    public BreakpointManager getBreakpointManager() {
        if (this.bpManager == null) {
            this.bpManager = new BreakpointManager(ModeReplacement.getInstance().getSimulation());
            ModeReplacement.getInstance().getSimulation().setBreakpointManager(this.bpManager);
        }
        return this.bpManager;
    }

    public static ImageIcon getRenewIcon() {
        return new ImageIcon(((Object)((Object)GuiPlugin.getCurrent())).getClass().getResource("/de/renew/gui/images/renew.png"));
    }

    private class SimulationStateListener
    extends SimulatorExtensionAdapter {
        private SimulationStateListener() {
        }

        public void simulationSetup(SimulationEnvironment simulationEnvironment) {
            this.enforceMenuUpdate(false);
        }

        public void simulationTerminated() {
            this.enforceMenuUpdate(true);
        }

        private void enforceMenuUpdate(final boolean bl) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (GuiPlugin.this.isGuiPresent()) {
                        GuiPlugin.this._gui.menuStateChanged();
                        if (bl) {
                            GuiPlugin.this._gui.cleanupSimulationWindows();
                        }
                    }
                }
            });
        }
    }
}

