/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureWithHighlight;
import java.util.Vector;

public class HighlightAssociateCommand
extends UndoableCommand {
    public HighlightAssociateCommand(String string) {
        super(string);
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        DrawingView drawingView = this.getEditor().view();
        if (drawing instanceof CPNDrawing && drawingView.selectionCount() == 2) {
            FigureEnumeration figureEnumeration = drawingView.selectionElements();
            while (figureEnumeration.hasMoreElements()) {
                if (!(figureEnumeration.nextFigure() instanceof FigureWithHighlight)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            CPNDrawing cPNDrawing = (CPNDrawing)this.getEditor().drawing();
            DrawingView drawingView = this.getEditor().view();
            Vector vector = drawingView.selection();
            int n = -1;
            if (vector.elementAt(0) instanceof FigureWithHighlight) {
                n = 0;
            } else if (vector.elementAt(1) instanceof FigureWithHighlight) {
                n = 1;
            }
            FigureWithHighlight figureWithHighlight = (FigureWithHighlight)vector.elementAt(n);
            Figure figure = (Figure)vector.elementAt(1 - n);
            cPNDrawing.setHighlightFigure(figureWithHighlight, figure);
            this.getEditor().showStatus("Highlight associated!");
            return true;
        }
        this.getEditor().showStatus("Select a node (place or transition) and another figure!");
        return false;
    }
}

