/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GUIProperties {
    public static Logger logger = Logger.getLogger(GUIProperties.class);
    private static Properties _properties = new Properties();
    private static Map<String, Boolean> lastBoolResults = new HashMap<String, Boolean>();

    private GUIProperties() {
    }

    public static void setProperties(Properties properties) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setting GUI properties:" + String.valueOf(properties)), new Throwable("StackTrace"));
        }
        _properties = properties;
    }

    public static Properties getProperties() {
        return _properties;
    }

    protected static boolean returnBool(String string, String string2) {
        String string3 = "de.renew." + string;
        String string4 = _properties.getProperty(string3);
        if (string4 == null && (string4 = System.getProperty(string3)) != null) {
            _properties.setProperty(string, string4);
        }
        if (string4 == null) {
            string4 = "false";
            _properties.setProperty(string, string4);
        } else if ("".equals(string4)) {
            string4 = "true";
            _properties.setProperty(string, string4);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: " + string3 + "=" + string4));
        }
        Boolean bl = Boolean.valueOf(string4);
        GUIProperties.printOptionalSetMessage(string3, bl, string2);
        return bl;
    }

    protected static void printOptionalSetMessage(String string, Boolean bl, String string2) {
        Boolean bl2 = lastBoolResults.get(string);
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        lastBoolResults.put(string, bl);
        if (!bl2.booleanValue() && bl.booleanValue() && string2 != null) {
            logger.debug((Object)(string2 + " activated."));
        } else if (bl2.booleanValue() && !bl.booleanValue() && string2 != null) {
            logger.debug((Object)(string2 + " deactivated."));
        }
    }

    protected static int returnInt(String string) {
        return GUIProperties.returnInt(string, -1);
    }

    protected static int returnInt(String string, int n) {
        String string2 = "de.renew." + string;
        String string3 = _properties.getProperty(string2);
        int n2 = n;
        if (string3 == null) {
            string3 = System.getProperty(string2);
        }
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
                _properties.setProperty(string, Integer.toString(n2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)("Error reading property " + string2 + "=" + string3 + ": " + String.valueOf(numberFormatException)));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: " + string2 + "=" + n2));
        }
        return n2;
    }

    public static boolean avoidFrameReshape() {
        boolean bl = GUIProperties.returnBool("avoidFrameReshape", "Frame reshaping");
        return bl;
    }

    public static int loadServerPort() {
        return GUIProperties.returnInt("loadServerPort", 65111);
    }

    public static int menuFontSize() {
        return GUIProperties.returnInt("menuFontSize");
    }

    public static boolean windowResizable() {
        String string = _properties.getProperty("de.renew.windowResizable");
        if (string == null && (string = System.getProperty("de.renew.windowResizable")) != null) {
            _properties.setProperty("de.renew.windowResizable", string);
        }
        if (string == null) {
            if (System.getProperty("os.name").indexOf("Win") >= 0) {
                string = "true";
                _properties.setProperty("de.renew.windowResizable", string);
            }
        } else if ("".equals(string)) {
            string = "true";
            _properties.setProperty("de.renew.windowResizable", string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: de.renew.windowResizable=" + string));
        }
        Boolean bl = Boolean.valueOf(string);
        GUIProperties.printOptionalSetMessage("de.renew.windowResizable", bl, "Menu frame resizability");
        return bl;
    }

    public static int defaultFontSize() {
        return GUIProperties.returnInt("defaultFontSize");
    }

    public static boolean customToolBorders() {
        return GUIProperties.returnBool("customToolBorders", "Drawing old-style Renew tool buttons.");
    }

    public static boolean noGraphics() {
        return GUIProperties.returnBool("noGraphics", null);
    }
}

