/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class GenericAppenderEditor
extends JPanel {
    private static final Logger logger = Logger.getLogger(GenericAppenderEditor.class);
    private static final Set<Class<?>> supportedTypes = new HashSet();
    private Appender appender;
    private JPanel fieldsPanel;
    private JPanel buttonPanel;
    private Map<String, JComponent> attributeFields = new Hashtable<String, JComponent>();
    private Map<String, Class<?>> attributeTypes;
    private int row = 0;

    public GenericAppenderEditor(Appender appender) {
        this.appender = appender;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fieldsPanel = new JPanel();
        this.fieldsPanel.setLayout(new GridBagLayout());
        this.add((Component)this.fieldsPanel, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "South");
        this.attributeTypes = this.findAttributeTypes(this.appender);
        String[] stringArray = this.attributeTypes.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getCurrentValue(stringArray[i], this.appender);
            JComponent jComponent = this.createComponents(stringArray[i], this.attributeTypes.get(stringArray[i]), object);
            if (jComponent == null) continue;
            this.attributeFields.put(stringArray[i], jComponent);
        }
    }

    private JComponent createComponents(String string, Class<?> clazz, Object object) {
        Serializable serializable;
        JComponent jComponent = null;
        if (clazz == Number.class || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Byte.TYPE || clazz == Double.TYPE || clazz == Float.TYPE || clazz == Long.TYPE) {
            serializable = new SpinnerNumberModel();
            ((SpinnerNumberModel)serializable).setValue(object);
            jComponent = new JSpinner((SpinnerModel)((Object)serializable));
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                ((SpinnerNumberModel)serializable).setMinimum(new Integer(Integer.MIN_VALUE));
                ((SpinnerNumberModel)serializable).setMaximum(new Integer(Integer.MAX_VALUE));
                ((SpinnerNumberModel)serializable).setStepSize(new Integer(1));
            } else if (clazz == Byte.TYPE || clazz == Byte.class) {
                ((SpinnerNumberModel)serializable).setMinimum(new Byte(-128));
                ((SpinnerNumberModel)serializable).setMaximum(new Byte(127));
                ((SpinnerNumberModel)serializable).setStepSize(new Integer(1));
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                ((SpinnerNumberModel)serializable).setMinimum(new Long(Long.MIN_VALUE));
                ((SpinnerNumberModel)serializable).setMaximum(new Long(Long.MAX_VALUE));
                ((SpinnerNumberModel)serializable).setStepSize(new Integer(1));
            } else if (clazz == Float.TYPE || clazz == Float.class) {
                ((SpinnerNumberModel)serializable).setMinimum(new Float(Float.MIN_VALUE));
                ((SpinnerNumberModel)serializable).setMaximum(new Float(Float.MAX_VALUE));
            } else if (clazz == Double.TYPE || clazz == Double.class) {
                ((SpinnerNumberModel)serializable).setMinimum(new Double(Double.MIN_VALUE));
                ((SpinnerNumberModel)serializable).setMaximum(new Double(Double.MAX_VALUE));
            }
        } else if (clazz == Integer.TYPE) {
            serializable = new SpinnerNumberModel();
            ((SpinnerNumberModel)serializable).setValue(object);
            jComponent = new JSpinner((SpinnerModel)((Object)serializable));
        } else if (String.class.isAssignableFrom(clazz)) {
            jComponent = new JTextField((String)object);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            jComponent = new JCheckBox();
        } else if (Priority.class.isAssignableFrom(clazz)) {
            serializable = new Priority[]{Level.ALL, Level.INFO, Level.DEBUG, Level.ERROR, Level.FATAL, Level.OFF};
            jComponent = new JComboBox((E[])serializable);
            ((JComboBox)jComponent).getModel().setSelectedItem(object);
        } else if (Layout.class.isAssignableFrom(clazz)) {
            jComponent = object != null ? new JTextField(((PatternLayout)object).getConversionPattern()) : new JTextField();
        }
        if (jComponent != null) {
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).gridy = this.row;
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagConstraints)serializable).gridheight = 1;
            ((GridBagConstraints)serializable).anchor = 13;
            JLabel jLabel = new JLabel(string + ":");
            ((GridBagLayout)this.fieldsPanel.getLayout()).setConstraints(jLabel, (GridBagConstraints)serializable);
            this.fieldsPanel.add(jLabel);
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 1;
            ((GridBagConstraints)serializable).gridy = this.row++;
            ((GridBagConstraints)serializable).weightx = 0.7;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagConstraints)serializable).gridheight = 1;
            ((GridBagLayout)this.fieldsPanel.getLayout()).setConstraints(jComponent, (GridBagConstraints)serializable);
            this.fieldsPanel.add(jComponent);
        }
        return jComponent;
    }

    private Map<String, Class<?>> findAttributeTypes(Appender appender) {
        Hashtable hashtable = new Hashtable();
        Class<?> clazz = appender.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("set") || methodArray[i].getParameterTypes().length != 1 || !supportedTypes.contains(methodArray[i].getParameterTypes()[0])) continue;
            String string = methodArray[i].getName().substring("set".length());
            hashtable.put(string, methodArray[i].getParameterTypes()[0]);
        }
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < methodArray.length; ++i) {
            String string;
            if (!methodArray[i].getName().startsWith("get") || !hashtable.containsKey(string = methodArray[i].getName().substring("get".length())) || methodArray[i].getParameterTypes().length != 0 || !supportedTypes.contains(methodArray[i].getReturnType())) continue;
            treeMap.put(string, methodArray[i].getReturnType());
        }
        return treeMap;
    }

    private Object getCurrentValue(String string, Appender appender) {
        Object object = null;
        Class<?> clazz = appender.getClass();
        try {
            Method method = clazz.getMethod("get" + string, new Class[0]);
            object = method.invoke((Object)appender, new Object[0]);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return object;
    }

    private void setValue(Appender appender, String string, Object object) {
        Class<?> clazz = appender.getClass();
        if (object != null) {
            Class<Object> clazz2 = object.getClass();
            if (clazz2 == Level.class) {
                clazz2 = Priority.class;
            } else if (clazz2 == PatternLayout.class) {
                clazz2 = Layout.class;
            }
            Method method = null;
            try {
                method = clazz.getMethod("set" + string, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    if (clazz2 == Integer.class) {
                        method = clazz.getMethod("set" + string, Integer.TYPE);
                    } else if (clazz2 == Byte.class) {
                        method = clazz.getMethod("set" + string, Byte.TYPE);
                    } else if (clazz2 == Long.class) {
                        method = clazz.getMethod("set" + string, Long.TYPE);
                    } else if (clazz2 == Float.class) {
                        method = clazz.getMethod("set" + string, Float.TYPE);
                    } else if (clazz2 == Double.class) {
                        method = clazz.getMethod("set" + string, Double.TYPE);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            try {
                if (method != null) {
                    object = method.invoke((Object)appender, object);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void applyChanges() {
        String[] stringArray = this.attributeFields.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Class<?> clazz = this.attributeTypes.get(stringArray[i]);
            JComponent jComponent = this.attributeFields.get(stringArray[i]);
            if (clazz == null || jComponent == null) continue;
            if (jComponent instanceof JTextField) {
                object = ((JTextField)jComponent).getText();
                if (stringArray[i].equals("Layout")) {
                    this.setValue(this.appender, stringArray[i], new PatternLayout((String)object));
                    continue;
                }
                this.setValue(this.appender, stringArray[i], object);
                continue;
            }
            if (jComponent instanceof JSpinner) {
                object = ((JSpinner)jComponent).getModel();
                this.setValue(this.appender, stringArray[i], object.getValue());
                continue;
            }
            if (jComponent instanceof JCheckBox) {
                this.setValue(this.appender, stringArray[i], new Boolean(((JCheckBox)jComponent).isSelected()));
                continue;
            }
            if (!(jComponent instanceof JComboBox)) continue;
            this.setValue(this.appender, stringArray[i], ((JComboBox)jComponent).getModel().getSelectedItem());
        }
    }

    static {
        supportedTypes.add(Integer.class);
        supportedTypes.add(Long.class);
        supportedTypes.add(Float.class);
        supportedTypes.add(Double.class);
        supportedTypes.add(Boolean.class);
        supportedTypes.add(String.class);
        supportedTypes.add(Byte.class);
        supportedTypes.add(Integer.TYPE);
        supportedTypes.add(Long.TYPE);
        supportedTypes.add(Float.TYPE);
        supportedTypes.add(Double.TYPE);
        supportedTypes.add(Boolean.TYPE);
        supportedTypes.add(Byte.TYPE);
        supportedTypes.add(Priority.class);
        supportedTypes.add(Layout.class);
    }
}

