/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.diff;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.diff.FileDiffer;
import de.renew.navigator.gui.FileTreeNode;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class FileDiffAction
extends NavigatorAction {
    public static final String ICON = "/de/renew/navigator/diff/images/icon.gif";
    private final NavigatorPlugin plugin;
    private final FileDiffer differ;

    public FileDiffAction(NavigatorPlugin navigatorPlugin, FileDiffer fileDiffer) {
        super("Diffs two files.", ICON, null);
        this.plugin = navigatorPlugin;
        this.differ = fileDiffer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTree jTree = this.plugin.getTree();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 2) {
            TreeNode treeNode = (TreeNode)treePathArray[0].getLastPathComponent();
            TreeNode treeNode2 = (TreeNode)treePathArray[1].getLastPathComponent();
            if (treeNode instanceof FileTreeNode && treeNode2 instanceof FileTreeNode) {
                FileTreeNode fileTreeNode = (FileTreeNode)treeNode;
                FileTreeNode fileTreeNode2 = (FileTreeNode)treeNode2;
                File file = fileTreeNode.getFile();
                File file2 = fileTreeNode2.getFile();
                if (!file.isDirectory() && !file2.isDirectory()) {
                    this.differ.showFileDiff(file, file2);
                }
            }
        }
    }
}

