/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import de.renew.gui.GraphNode;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class GraphLayout
extends FigureChangeAdapter {
    public static double DEFAULT_LENGTH_FACTOR = 1.0;
    public static double DEFAULT_REPULSION_STRENGTH = 2.0;
    public static double DEFAULT_REPULSION_LIMIT = 400.0;
    public static double DEFAULT_SPRING_STRENGTH = 0.05;
    public static double DEFAULT_TORQUE_STRENGTH = 0.25;
    public static double DEFAULT_FRICTION_FACTOR = 0.75;
    public double lengthFactor = DEFAULT_LENGTH_FACTOR;
    public double repulsionStrength = DEFAULT_REPULSION_STRENGTH;
    public double repulsionLimit = DEFAULT_REPULSION_LIMIT;
    public double springStrength = DEFAULT_SPRING_STRENGTH;
    public double torqueStrength = DEFAULT_TORQUE_STRENGTH;
    public double frictionFactor = DEFAULT_FRICTION_FACTOR;
    int repulsionType = 0;
    private Hashtable<Figure, GraphNode> nodes = new Hashtable();
    private Hashtable<ConnectionFigure, Double> edges = new Hashtable();

    private GraphNode getGraphNode(Figure figure) {
        return this.nodes.get(figure);
    }

    private double len(Figure figure) {
        return this.edges.get(figure) * this.lengthFactor;
    }

    public void addNode(Figure figure) {
        this.nodes.put(figure, new GraphNode(figure));
        figure.addFigureChangeListener((FigureChangeListener)this);
    }

    public void addEdge(ConnectionFigure connectionFigure, int n) {
        Dimension dimension = connectionFigure.start().owner().size();
        Dimension dimension2 = connectionFigure.end().owner().size();
        int n2 = Math.max(dimension.width, dimension.height) / 2 + Math.max(dimension2.width, dimension2.height) / 2 + n;
        this.edges.put(connectionFigure, new Double(n2));
    }

    public synchronized void relax() {
        GraphNode graphNode;
        Object object;
        if (this.nodes == null) {
            return;
        }
        Enumeration<ConnectionFigure> enumeration = this.edges.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            double d = this.len((Figure)object);
            graphNode = this.getGraphNode(object.start().owner());
            GraphNode graphNode2 = this.getGraphNode(object.end().owner());
            double d2 = graphNode2.x - graphNode.x;
            double d3 = graphNode2.y - graphNode.y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            if (!(d4 > 0.0)) continue;
            double d5 = this.springStrength * (d - d4) / d4;
            double d6 = d5 * d2;
            double d7 = d5 * d3;
            double d8 = Math.atan2(d2, d3);
            double d9 = -Math.sin(4.0 * d8);
            graphNode2.dx += (d6 += this.torqueStrength * d3 * d9 / d4);
            graphNode2.dy += (d7 += -this.torqueStrength * d2 * d9 / d4);
            graphNode.dx += -d6;
            graphNode.dy += -d7;
        }
        object = this.nodes.elements();
        while (object.hasMoreElements()) {
            GraphNode graphNode3 = (GraphNode)object.nextElement();
            double d = 0.0;
            double d10 = 0.0;
            Enumeration<GraphNode> enumeration2 = this.nodes.elements();
            while (enumeration2.hasMoreElements()) {
                GraphNode graphNode4 = enumeration2.nextElement();
                if (graphNode3 == graphNode4) continue;
                double d11 = graphNode3.x - graphNode4.x;
                double d12 = graphNode3.y - graphNode4.y;
                double d13 = d11 * d11 + d12 * d12;
                double d14 = Math.sqrt(d13);
                if (d14 == 0.0) {
                    d += this.repulsionStrength * Math.random();
                    d10 += this.repulsionStrength * Math.random();
                    continue;
                }
                if (!(d14 < this.repulsionLimit)) continue;
                d11 /= this.repulsionLimit;
                d12 /= this.repulsionLimit;
                d14 /= this.repulsionLimit;
                double d15 = 0.0;
                switch (this.repulsionType) {
                    case 0: {
                        d15 = 0.5 * (1.0 - d14) / d14;
                        break;
                    }
                    case 1: {
                        d15 = 1.0 - d14;
                        break;
                    }
                    case 2: {
                        d15 = 2.0 * (1.0 - d14) * (1.0 - d14);
                    }
                }
                d += (d15 *= this.repulsionStrength) * d11;
                d10 += d15 * d12;
            }
            graphNode3.dx += d;
            graphNode3.dy += d10;
        }
        Enumeration<Figure> enumeration3 = this.nodes.keys();
        while (enumeration3.hasMoreElements()) {
            Figure figure = enumeration3.nextElement();
            graphNode = this.getGraphNode(figure);
            if (!Boolean.TRUE.equals(figure.getAttribute("Location"))) {
                graphNode.x += Math.max(-5.0, Math.min(5.0, graphNode.dx));
                graphNode.y += Math.max(-5.0, Math.min(5.0, graphNode.dy));
                Point point = figure.center();
                figure.moveBy((int)Math.round(graphNode.x) - point.x, (int)Math.round(graphNode.y) - point.y);
                if (graphNode.x < 0.0) {
                    graphNode.x = 0.0;
                }
                if (graphNode.y < 0.0) {
                    graphNode.y = 0.0;
                }
            }
            graphNode.dx *= this.frictionFactor;
            graphNode.dy *= this.frictionFactor;
        }
    }

    public synchronized void figureChanged(FigureChangeEvent figureChangeEvent) {
        Figure figure;
        if (this.nodes != null && this.nodes.containsKey(figure = figureChangeEvent.getFigure())) {
            this.getGraphNode(figure).update();
        }
    }

    public void remove() {
        if (this.nodes != null) {
            Enumeration<Figure> enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Figure figure = enumeration.nextElement();
                figure.removeFigureChangeListener((FigureChangeListener)this);
            }
            this.nodes = null;
            this.edges = null;
        }
    }

    synchronized void randomInit(double d, double d2, double d3, double d4) {
        if (this.nodes != null) {
            Enumeration<GraphNode> enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                GraphNode graphNode = enumeration.nextElement();
                graphNode.x = d + Math.random() * d3;
                graphNode.y = d2 + Math.random() * d4;
            }
        }
    }

    synchronized void moveBy(int n, int n2) {
        if (this.nodes != null) {
            Enumeration<Figure> enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().moveBy(n, n2);
            }
        }
    }
}

