/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.NodeParser;
import de.renew.plugin.PluginManager;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransitionParser
extends NodeParser {
    private static Logger logger = Logger.getLogger(TransitionParser.class);
    private String subtypeClass = null;

    public TransitionParser(Element element, NetConverter netConverter) {
        super(element, netConverter);
        NodeList nodeList = element.getElementsByTagName("toolspecific");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagName("subtype");
            int n = nodeList2.getLength();
            if (n <= 0) continue;
            if (n > 1) {
                logger.warn((Object)(TransitionParser.class.getSimpleName() + ": more than one subtype element."));
            }
            Element element2 = (Element)nodeList2.item(0);
            this.subtypeClass = element2.getAttribute("class");
            return;
        }
    }

    @Override
    public FigureWithID createObject() {
        if (this.subtypeClass != null) {
            try {
                return (FigureWithID)Class.forName(this.subtypeClass, true, PluginManager.getInstance().getBottomClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                logger.error((Object)(TransitionParser.class.getSimpleName() + ": " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return new TransitionFigure();
    }
}

