/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.FileSet;

public class LaTeX
extends Task {
    private String latexfile = null;
    private String bibtexfile = null;
    private File latexdir = null;
    private boolean bibtex = false;
    private boolean pdftex = false;
    private boolean psgztex = false;
    private boolean clean = false;
    private Delete delete = null;
    private final String[] deletePatterns = new String[]{"*.aux", "*.log", "*.toc", "*.lof", "*.lot", "*.bbl", "*.blg", "*.out"};

    public void init() {
        this.latexdir = this.getProject().getBaseDir();
    }

    public void setLatexfile(String string) {
        this.latexfile = string;
        this.bibtexfile = this.latexfile.substring(0, this.latexfile.lastIndexOf(".tex"));
    }

    public void setDirectory(File file) {
        this.latexdir = file;
    }

    public void setBibtex(boolean bl) {
        this.bibtex = bl;
    }

    public void setPdftex(boolean bl) {
        this.pdftex = bl;
    }

    public void setPsgztex(boolean bl) {
        this.psgztex = bl;
    }

    public void setClean(boolean bl) {
        this.clean = bl;
    }

    public void execute() throws BuildException {
        this.log("Running LaTeX now!", 3);
        this.dump();
        this.log("Calling latex on " + this.latexfile);
        this.runLaTeX();
        if (this.bibtex) {
            this.log("bibtex...");
            this.runBIBTeX();
        }
        this.log("latex");
        this.runLaTeX();
        this.log("latex");
        this.runLaTeX();
        if (this.psgztex) {
            this.log("Creating ps from dvi file...");
            this.runDvips();
            if (this.pdftex) {
                this.log("Creating pdf from ps file");
                this.runPs2pdf();
            }
            this.log("Running gzip on ps file");
            this.runGzip();
        }
        if (this.delete == null) {
            this.delete = this.createDefaultDelete();
        }
        this.log("run Delete", 3);
        this.delete.execute();
        this.log("Done.");
    }

    public Object createDelete() {
        this.log("Delete is created");
        this.delete = (Delete)this.getProject().createTask("delete");
        return this.delete;
    }

    private Delete createDefaultDelete() {
        Delete delete = null;
        delete = (Delete)this.getProject().createTask("delete");
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.latexdir);
        for (int i = 0; i < this.deletePatterns.length; ++i) {
            fileSet.createInclude().setName(this.deletePatterns[i]);
        }
        delete.addFileset(fileSet);
        delete.setVerbose(true);
        return delete;
    }

    private final int runLaTeX() throws BuildException {
        String string = "latex";
        String[] stringArray = new String[]{string, "\\nonstopmode\\input{" + this.latexfile + "}"};
        return this.runCommand(stringArray, false);
    }

    private final int runBIBTeX() throws BuildException {
        String[] stringArray = new String[]{"bibtex", this.bibtexfile};
        return this.runCommand(stringArray, false);
    }

    private final int runDvips() throws BuildException {
        String[] stringArray = new String[]{"dvips", "-D600", "-o", this.bibtexfile + ".ps", this.bibtexfile};
        return this.runCommand(stringArray, true);
    }

    private final int runGzip() throws BuildException {
        String[] stringArray = new String[]{"gzip", "-f", this.bibtexfile + ".ps"};
        return this.runCommand(stringArray, false);
    }

    private final int runPs2pdf() throws BuildException {
        String[] stringArray = new String[]{"ps2pdf", this.bibtexfile + ".ps"};
        return this.runCommand(stringArray, false);
    }

    private final int runCommand(String[] stringArray, boolean bl) throws BuildException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        this.log("running command: " + stringBuffer.toString(), 3);
        try {
            Execute execute = null;
            execute = bl ? new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 4, 4), null) : new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 4, 1), null);
            execute.setWorkingDirectory(this.latexdir);
            execute.setCommandline(stringArray);
            execute.setAntRun(this.getProject());
            n = execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        this.log("command exitcode = " + n, 3);
        return n;
    }

    private void dump() {
        this.log("latexfile  = " + this.latexfile, 3);
        this.log("bibtexfile = " + this.latexfile, 3);
        this.log("latexdir   = " + String.valueOf(this.latexdir), 3);
        this.log("bibtex     = " + this.bibtex, 3);
        this.log("bibtex     = " + this.bibtex, 3);
        this.log("clean      = " + this.clean, 3);
        this.log("delete     = " + String.valueOf(this.delete), 3);
    }
}

