/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HashedRelation<K, V>
implements Serializable {
    private Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    public synchronized void put(K k, V v) {
        Set<Object> set;
        if (this.map.containsKey(k)) {
            set = this.map.get(k);
        } else {
            set = new HashSet();
            this.map.put(k, set);
        }
        set.add(v);
    }

    public synchronized void remove(K k, V v) {
        Set<V> set = this.map.get(k);
        set.remove(v);
        if (set.isEmpty()) {
            this.map.remove(k);
        }
    }

    public synchronized Set<K> keys() {
        return this.map.keySet();
    }

    public synchronized Set<V> elementsAt(K k) {
        if (this.map.containsKey(k)) {
            Set<V> set = this.map.get(k);
            return set;
        }
        return Collections.emptySet();
    }

    public synchronized int sizeAt(Object object) {
        if (this.map.containsKey(object)) {
            Set<V> set = this.map.get(object);
            return set.size();
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("de.renew.util.HashedRelation( ");
        for (K k : this.map.keySet()) {
            stringBuffer.append(k);
            stringBuffer.append(" -> (");
            boolean bl = true;
            for (V v : this.map.get(k)) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(v);
            }
            stringBuffer.append(") ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

