/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ScriptCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(ScriptCommand.class);
    String[] lastScript;

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray.length > 1) {
            printStream.println("ScriptCommand: more than one parameter given: using only " + stringArray[0]);
        }
        Collection<String> collection = this.readFile(stringArray[0], printStream);
        Collection<CommandArgumentTuple> collection2 = this.createCommands(collection, printStream);
        Iterator<CommandArgumentTuple> iterator = collection2.iterator();
        while (iterator.hasNext()) {
            try {
                CommandArgumentTuple commandArgumentTuple = iterator.next();
                commandArgumentTuple.execute(printStream);
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)("PluginManager.PromptThread: an exeption occurred: " + String.valueOf(runtimeException)));
                logger.error((Object)runtimeException.getMessage(), (Throwable)runtimeException);
            }
        }
    }

    @Override
    public String getDescription() {
        return "reads an input file and interprets every line as a PluginManager command";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> readFile(String string, PrintStream printStream) {
        printStream.println("ScriptCommand: Try to load file " + string);
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        String string2 = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while (string2 != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                vector.add(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            printStream.println("ScriptCommand: file " + string + " not found.");
        }
        catch (IOException iOException) {
            logger.error((Object)("ScriptCommand: exception when reading " + string + ": "), (Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return vector;
    }

    private Collection<CommandArgumentTuple> createCommands(Collection<String> collection, PrintStream printStream) {
        Map<String, CLCommand> map = PluginManager.getInstance().getCLCommands();
        Vector<CommandArgumentTuple> vector = new Vector<CommandArgumentTuple>();
        Iterator<String> iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!bl && string.trim().startsWith("/*")) {
                logger.debug((Object)"Block comment started");
                bl = true;
            }
            if (bl && (string.trim().endsWith("*/") || string.trim().equals("*/"))) {
                logger.debug((Object)"Block comment ended");
                bl = false;
                continue;
            }
            logger.debug((Object)("CONVERT TO COMMAND " + string));
            List<String> list = this.splitString(string);
            if (string.trim().length() == 0 || bl || list.size() == 0 || list.get(0).trim().startsWith("#")) continue;
            CLCommand cLCommand = map.get(list.get(0));
            if (cLCommand == null) {
                printStream.println("ScriptCommand: unknown command: " + list.get(0));
                continue;
            }
            String[] stringArray = new String[list.size() - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i + 1);
            }
            CommandArgumentTuple commandArgumentTuple = new CommandArgumentTuple(cLCommand, stringArray);
            vector.add(commandArgumentTuple);
        }
        return vector;
    }

    protected List<String> splitString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1).replace("\"", ""));
        }
        return arrayList;
    }

    @Override
    public String getArguments() {
        return "fileNames";
    }

    private class CommandArgumentTuple {
        private CLCommand _command;
        private String[] _arguments;

        public CommandArgumentTuple(CLCommand cLCommand, String[] stringArray) {
            this._command = cLCommand;
            this._arguments = stringArray;
        }

        public void execute(PrintStream printStream) {
            this._command.execute(this._arguments, printStream);
        }
    }
}

