/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.load.AbstractPluginLoader;
import de.renew.plugin.load.PluginInstantiationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;

public class SimplePluginLoader
extends AbstractPluginLoader {
    public SimplePluginLoader(PluginClassLoader pluginClassLoader, ServiceContainer serviceContainer) {
        super(pluginClassLoader, serviceContainer);
    }

    @Override
    protected IPlugin createPlugin(PluginProperties pluginProperties, Class<? extends IPlugin> clazz) throws PluginInstantiationException {
        try {
            Class[] classArray = new Class[]{pluginProperties.getClass()};
            Constructor<? extends IPlugin> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{pluginProperties};
            return constructor.newInstance(objectArray);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new PluginInstantiationException(pluginProperties.getName(), reflectiveOperationException);
        }
    }

    public static class PluginConfigFinder {
        public static InputStream getConfigInputStream(URL uRL) throws MalformedURLException, IOException {
            URL uRL2 = new URL(uRL, "plugin.cfg");
            InputStream inputStream = null;
            try {
                inputStream = uRL2.openStream();
            }
            catch (Exception exception) {
                Object object = uRL.toExternalForm();
                int n = ((String)object).lastIndexOf(33);
                if (n > -1) {
                    object = ((String)object).substring(0, n) + "/plugin.cfg";
                    AbstractPluginLoader.logger.debug((Object)("trying alternate URL for plugin.cfg: " + (String)object));
                }
                uRL2 = new URL((String)object);
                inputStream = uRL2.openStream();
            }
            return inputStream;
        }
    }
}

