/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.PluginProperties;
import de.renew.plugin.locate.PluginFileFinder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginSubDirFinder
extends PluginFileFinder {
    public static Logger logger = Logger.getLogger(PluginSubDirFinder.class);

    public PluginSubDirFinder(URL uRL) {
        super(uRL);
    }

    @Override
    protected File[] getPluginFiles(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        return fileArray;
    }

    @Override
    protected Collection<PluginProperties> getPluginConfigurations(File[] fileArray) {
        Vector<PluginProperties> vector = new Vector<PluginProperties>();
        for (int i = 0; i < fileArray.length; ++i) {
            PluginProperties pluginProperties = this.getPluginConfigfromDirectory(fileArray[i]);
            if (pluginProperties == null) continue;
            vector.add(pluginProperties);
        }
        return vector;
    }

    protected PluginProperties getPluginConfigfromDirectory(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.equals("plugin.cfg");
                }
            });
            File file2 = null;
            if (fileArray.length > 0) {
                file2 = fileArray[0];
                if (fileArray.length > 1) {
                    logger.warn((Object)("PluginSubDirFinder: " + String.valueOf(file) + " contains more than one plugin.cfg file! using only " + String.valueOf(file)));
                }
            } else {
                logger.debug((Object)("PluginSubDirFinder: no plugin.cfg found in " + String.valueOf(file)));
            }
            if (file2 != null) {
                return this.createPluginConfig(file2);
            }
        }
        return null;
    }

    protected PluginProperties createPluginConfig(File file) {
        try {
            URL uRL = file.toURI().toURL();
            FileInputStream fileInputStream = new FileInputStream(file);
            PluginProperties pluginProperties = new PluginProperties(uRL, fileInputStream);
            return pluginProperties;
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("PluginSubDirFinder: could not create URL from " + String.valueOf(file) + ": " + String.valueOf(malformedURLException)));
        }
        catch (Exception exception) {
            logger.error((Object)("PluginSubDirFinder: " + String.valueOf(exception)));
        }
        return null;
    }

    private static void list(Collection<?> collection) {
        for (Object obj : collection) {
            System.out.println(obj);
        }
    }

    public static void main(String[] stringArray) {
        Collection<PluginProperties> collection = new PluginSubDirFinder(null).findPluginLocations();
        System.out.println("found the following locations:");
        PluginSubDirFinder.list(collection);
    }
}

