/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.OutlineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.Connector;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class DiamondFigure
extends RectangleFigure
implements OutlineFigure {
    public DiamondFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public DiamondFigure(Point point, Point point2) {
        super(point, point2);
    }

    public Shape polygon() {
        return this.polygon(0);
    }

    public Shape polygon(int n) {
        Rectangle rectangle = this.displayBox();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        generalPath.lineTo(rectangle.x + rectangle.width / 2, rectangle.y);
        generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height / 2);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public Polygon outline() {
        Rectangle rectangle = this.displayBox();
        rectangle.setRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height / 2);
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        return polygon;
    }

    @Override
    public Connector connectorAt(int n, int n2) {
        return new ChopPolygonConnector(this);
    }

    @Override
    public void drawBackground(Graphics graphics) {
        graphics.setColor(this.getFillColor());
        ((Graphics2D)graphics).fill(this.polygon());
    }

    @Override
    public void drawFrame(Graphics graphics) {
        graphics.setColor(this.getFrameColor());
        ((Graphics2D)graphics).draw(this.polygon());
    }

    @Override
    public Insets connectionInsets() {
        Rectangle rectangle = this.displayBox();
        return new Insets(rectangle.height / 2, rectangle.width / 2, rectangle.height / 2, rectangle.width / 2);
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        return this.polygon().contains(n, n2);
    }
}

