/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class ChopPieConnector
extends ChopBoxConnector {
    public static final Logger logger = Logger.getLogger(ChopPieConnector.class);
    private PieFigure pieFig;

    public ChopPieConnector() {
    }

    public ChopPieConnector(PieFigure pieFigure) {
        super(pieFigure);
        this.pieFig = pieFigure;
    }

    @Override
    protected Point chop(Figure figure, Rectangle rectangle) {
        Rectangle rectangle2 = figure.displayBox();
        Point point = Geom.center(rectangle);
        double d = Geom.pointToAngle(rectangle2, point) + (rectangle2.intersection(rectangle).equals(rectangle2) ? Math.PI : 0.0);
        if (this.pieFig != null) {
            double d2;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Chopping for pieFig=" + String.valueOf(this.pieFig) + ", given target=" + String.valueOf(figure) + ", given source=" + String.valueOf(rectangle) + "."));
            }
            double d3 = d2 = PieFigure.normalizeAngle(-Math.toDegrees(d));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("   Angles are: angle_rad=" + d + ", angle_deg=" + d2 + ", pieFig.getStartAngle()=" + this.pieFig.getStartAngle() + ", pieFig.getEndAngle()=" + this.pieFig.getEndAngle() + "."));
            }
            if (this.pieFig.getStartAngle() < this.pieFig.getEndAngle()) {
                logger.debug((Object)"   start < end");
                if (d2 < this.pieFig.getStartAngle()) {
                    logger.debug((Object)"   angle < start < end");
                    d3 = this.pieFig.getStartAngle() - d2 < d2 + 360.0 - this.pieFig.getEndAngle() ? this.pieFig.getStartAngle() : this.pieFig.getEndAngle();
                } else if (this.pieFig.getEndAngle() < d2) {
                    logger.debug((Object)"   start < end < angle");
                    d3 = this.pieFig.getStartAngle() + 360.0 - d2 < d2 - this.pieFig.getEndAngle() ? this.pieFig.getStartAngle() : this.pieFig.getEndAngle();
                }
            } else if (this.pieFig.getStartAngle() > this.pieFig.getEndAngle() && this.pieFig.getStartAngle() > d2 && d2 > this.pieFig.getEndAngle()) {
                logger.debug((Object)"   end < angle < start");
                d3 = this.pieFig.getStartAngle() - d2 < d2 - this.pieFig.getEndAngle() ? this.pieFig.getStartAngle() : this.pieFig.getEndAngle();
            }
            if (d3 != d2) {
                d = -Math.toRadians(d3);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("   chosen angle is: deg=" + d3 + ", rad=" + d + "."));
                }
            } else {
                logger.debug((Object)"   chosen angle is unchanged.");
            }
        }
        return Geom.ovalAngleToPoint(rectangle2, d);
    }
}

