/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Fontkit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class FontSizeHandle
extends LocatorHandle {
    private Font fFont;
    private int fSize;
    private int fHeight;

    public FontSizeHandle(Figure figure, Locator locator) {
        super(figure, locator);
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        TextFigure textFigure = (TextFigure)this.owner();
        this.fFont = textFigure.getFont();
        this.fSize = this.fFont.getSize();
        Rectangle rectangle = textFigure.displayBox();
        this.fHeight = rectangle.height;
    }

    @Override
    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        TextFigure textFigure = (TextFigure)this.owner();
        int n5 = this.fSize * (this.fHeight + n2 - n4) / this.fHeight;
        textFigure.setFont(Fontkit.getFont(this.fFont.getName(), this.fFont.getStyle(), n5));
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

