/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopRoundRectangleConnector;
import CH.ifa.draw.figures.RadiusHandle;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class RoundRectangleFigure
extends AttributeFigure {
    private static final int DEFAULT_ARC = 8;
    private static final double DEFAULT_RATIO = 0.1;
    public static final String ARC_SCALE_ATTR = "ArcScale";
    private static final long serialVersionUID = 7907900248924036885L;
    private Rectangle fDisplayBox = null;
    private int fArcWidth = 8;
    private int fArcHeight = 8;
    private transient double fXRatio;
    private transient double fYRatio;
    private int roundRectangleSerializedDataVersion = 1;

    public RoundRectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
        this.fArcHeight = 8;
        this.fArcWidth = 8;
        this.fYRatio = 0.1;
        this.fXRatio = 0.1;
    }

    public RoundRectangleFigure(Point point, Point point2) {
        this.fXRatio = (double)this.fArcWidth / (double)(point2.x - point.x);
        this.fYRatio = (double)this.fArcHeight / (double)(point2.y - point.y);
        this.basicDisplayBox(point, point2);
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
        this.willChange();
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
        if (this.scaleArc()) {
            this.fArcWidth = (int)((double)(point2.x - point.x) * this.fXRatio);
            this.fArcHeight = (int)((double)(point2.y - point.y) * this.fYRatio);
        } else {
            this.recalculateRatio();
        }
        this.handlesChanged();
        this.changed();
    }

    private void recalculateRatio() {
        this.fXRatio = (double)this.getArcWidth() / (double)this.fDisplayBox.width;
        this.fYRatio = (double)this.getArcHeight() / (double)this.fDisplayBox.height;
    }

    private boolean scaleArc() {
        Boolean bl = (Boolean)this.getAttribute(ARC_SCALE_ATTR);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setArc(int n, int n2) {
        this.willChange();
        this.fArcWidth = n;
        this.fArcHeight = n2;
        this.recalculateRatio();
        this.changed();
    }

    public int getArcWidth() {
        if (this.fArcWidth > this.fDisplayBox.width) {
            return this.fDisplayBox.width;
        }
        return this.fArcWidth;
    }

    public int getArcHeight() {
        if (this.fArcHeight > this.fDisplayBox.height) {
            return this.fDisplayBox.height;
        }
        return this.fArcHeight;
    }

    public Point getArc() {
        return new Point(this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        BoxHandleKit.addHandles(this, vector);
        vector.addElement(new RadiusHandle(this));
        return vector;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    @Override
    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getArcWidth(), this.getArcHeight());
        ((Graphics2D)graphics).fill(float_);
    }

    @Override
    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getArcWidth(), this.getArcHeight());
        ((Graphics2D)graphics).draw(float_);
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(this.getArcWidth() / 2, this.getArcHeight() / 2, this.getArcWidth() / 2, this.getArcHeight() / 2);
    }

    @Override
    public Connector connectorAt(int n, int n2) {
        return new ChopRoundRectangleConnector(this);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        storableOutput.writeInt(this.fArcWidth);
        storableOutput.writeInt(this.fArcHeight);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.fArcWidth = storableInput.readInt();
        this.fArcHeight = storableInput.readInt();
        this.recalculateRatio();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.recalculateRatio();
    }
}

