/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatCommand;
import CH.ifa.draw.io.importFormats.ImportFormatMulti;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ImportHolderImpl
implements ImportHolder {
    public static Logger logger = Logger.getLogger(ImportHolderImpl.class);
    private List<ImportFormat> _importFormats;
    private CommandMenu _importMenu;

    public ImportHolderImpl() {
        this.setImportMenu(new CommandMenu("Import"));
        this.initImportFormatHolder();
    }

    public JMenu getImportMenu() {
        return this._importMenu;
    }

    private void initImportFormatHolder() {
        this.setImportFormats(new LinkedList<ImportFormat>());
        this.buildImportAll();
        this.loadDefaultImportFormats();
    }

    private List<ImportFormat> importFormats() {
        List<ImportFormat> list = null;
        list = this._importFormats;
        assert (list != null) : "Failure in GuiPlugin: result == null";
        return list;
    }

    private void setImportFormats(List<ImportFormat> list) {
        this._importFormats = list;
        assert (this.importFormats() != null) : "Failure in GuiPlugin: importFormats == null";
        assert (this.importFormats().equals(list)) : "Failure in GuiPlugin: importFormats != importFormats()";
    }

    private CommandMenu importMenu() {
        CommandMenu commandMenu = null;
        commandMenu = this._importMenu;
        assert (commandMenu != null) : "Failure in GuiPlugin: result == null";
        return commandMenu;
    }

    private void setImportMenu(CommandMenu commandMenu) {
        this._importMenu = commandMenu;
        assert (this.importMenu() != null) : "Failure in GuiPlugin: importMenu == null";
        assert (this.importMenu().equals(commandMenu)) : "Failure in GuiPlugin: importMenu != importMenu()";
    }

    private StatusDisplayer displayer() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        return drawApplication;
    }

    private DrawApplication application() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        return drawApplication;
    }

    private FileFilter[] fileFilterImport() {
        FileFilter[] fileFilterArray = null;
        LinkedList<FileFilter[]> linkedList = new LinkedList<FileFilter[]>();
        ImportFormat[] importFormatArray = this.allImportFormats();
        int n = 0;
        for (int i = 0; i < importFormatArray.length; ++i) {
            FileFilter[] fileFilterArray2 = this.buildFileFilter(importFormatArray[i]);
            n += fileFilterArray2.length;
            linkedList.add(fileFilterArray2);
        }
        fileFilterArray = new FileFilter[++n];
        for (FileFilter[] fileFilterArray2 : linkedList) {
            for (int i = 0; i < fileFilterArray2.length; ++i) {
                fileFilterArray[--n] = fileFilterArray2[i];
            }
        }
        fileFilterArray[0] = new NoFileFilter();
        return fileFilterArray;
    }

    private void loadDefaultImportFormats() {
    }

    private FileFilter[] buildFileFilter(ImportFormat importFormat) {
        FileFilter[] fileFilterArray = null;
        FileFilter fileFilter = importFormat.fileFilter();
        LinkedList<FileFilter> linkedList = new LinkedList<FileFilter>();
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter combinationFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : combinationFileFilter.getFileFilters()) {
                linkedList.add(fileFilter2);
            }
        } else {
            linkedList.add(fileFilter);
        }
        fileFilterArray = new FileFilter[linkedList.size()];
        for (int i = 0; i < fileFilterArray.length; ++i) {
            fileFilterArray[i] = (FileFilter)linkedList.get(i);
        }
        return fileFilterArray;
    }

    private void buildImportAll() {
        Command command = new Command("Import (any type)"){

            @Override
            public void execute() {
                ImportHolderImpl.this.displayer().showStatus("import...");
                File[] fileArray = DrawPlugin.getCurrent().getIOHelper().getLoadPath(ImportHolderImpl.this.fileFilterImport());
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        Object object;
                        File file = fileArray[i];
                        LinkedList<ImportFormat> linkedList = new LinkedList<ImportFormat>();
                        ImportFormat importFormat = null;
                        for (int j = 0; j < ImportHolderImpl.this.allImportFormats().length; ++j) {
                            try {
                                if (!ImportHolderImpl.this.allImportFormats()[j].canImport(file.toURI().toURL())) continue;
                                linkedList.add(ImportHolderImpl.this.allImportFormats()[j]);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                logger.error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
                                ImportHolderImpl.this.displayer().showStatus(malformedURLException.toString());
                            }
                        }
                        if (linkedList.size() == 1) {
                            importFormat = (ImportFormat)linkedList.get(0);
                        } else if (linkedList.size() > 1 && (object = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, linkedList.toArray(), linkedList.get(0))) != null) {
                            importFormat = (ImportFormat)object;
                        }
                        if (importFormat != null) {
                            try {
                                ImportHolderImpl.this.loadDrawings(new URL[]{file.toURI().toURL()}, importFormat);
                            }
                            catch (MalformedURLException malformedURLException) {
                                logger.error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
                                ImportHolderImpl.this.displayer().showStatus(malformedURLException.toString());
                            }
                            continue;
                        }
                        ImportHolderImpl.this.displayer().showStatus("no import Format");
                    }
                }
            }
        };
        this.importMenu().add(command);
    }

    private void loadDrawings(URL[] uRLArray, ImportFormat importFormat) {
        try {
            List<Drawing> list;
            if (uRLArray != null && uRLArray.length > 0 && (list = importFormat.importFiles(uRLArray)) != null) {
                for (Drawing drawing : list) {
                    this.application().openDrawing(drawing);
                    this.displayer().showStatus("import");
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.displayer().showStatus(exception.toString());
        }
    }

    private void buildImportFormat(ImportFormat importFormat, CommandMenu commandMenu) {
        ImportFormatCommand importFormatCommand = null;
        if (importFormat instanceof ImportFormatMulti) {
            ImportFormatMulti importFormatMulti = (ImportFormatMulti)importFormat;
            ImportFormat[] importFormatArray = importFormatMulti.allImportFormats();
            CommandMenu commandMenu2 = new CommandMenu(importFormatMulti.formatName());
            for (int i = 0; i < importFormatArray.length; ++i) {
                this.buildImportFormat(importFormatArray[i], commandMenu2);
            }
            commandMenu.add(commandMenu2);
        } else {
            importFormatCommand = this.generateImportCommand(importFormat);
            commandMenu.add(importFormatCommand);
        }
    }

    private ImportFormatCommand generateImportCommand(ImportFormat importFormat) {
        ImportFormatCommand importFormatCommand = null;
        importFormatCommand = new ImportFormatCommand(importFormat){

            @Override
            public void execute() {
                ImportHolderImpl.this.displayer().showStatus("import ...");
                File[] fileArray = DrawPlugin.getCurrent().getIOHelper().getLoadPath(this.format().fileFilter());
                URL[] uRLArray = new URL[fileArray.length];
                for (int i = 0; i < uRLArray.length; ++i) {
                    try {
                        uRLArray[i] = fileArray[i].toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
                        ImportHolderImpl.this.displayer().showStatus(malformedURLException.toString());
                    }
                }
                ImportHolderImpl.this.loadDrawings(uRLArray, this.format());
                ImportHolderImpl.this.application().toolDone();
                ImportHolderImpl.this.displayer().showStatus("import");
            }
        };
        assert (importFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return importFormatCommand;
    }

    @Override
    public void addImportFormat(ImportFormat importFormat) {
        logger.debug((Object)(String.valueOf(this.getClass()) + ": adding import format " + String.valueOf(importFormat)));
        this.importFormats().add(importFormat);
        this.buildImportFormat(importFormat, this.importMenu());
    }

    @Override
    public ImportFormat[] allImportFormats() {
        ImportFormat[] importFormatArray = null;
        importFormatArray = new ImportFormat[this.importFormats().size()];
        for (int i = 0; i < importFormatArray.length; ++i) {
            importFormatArray[i] = this.importFormats().get(i);
        }
        assert (importFormatArray != null) : "Failure in GuiPlugin: result == null";
        return importFormatArray;
    }

    @Override
    public void removeImportFormat(ImportFormat importFormat) {
        Component[] componentArray = this.importMenu().getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (!(componentArray[i] instanceof JMenuItem) || !(jMenuItem = (JMenuItem)componentArray[i]).getText().equals(importFormat.formatName())) continue;
            this.importMenu().remove(jMenuItem);
        }
        this.importFormats().remove(importFormat);
    }
}

