/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.AbstractTool;

public class UndoableTool
extends AbstractTool {
    private boolean didChange;

    public UndoableTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    @Override
    public void activate() {
        super.activate();
        this.fEditor.prepareUndoSnapshot();
        this.noChangesMade();
    }

    @Override
    public void deactivate() {
        if (this.didChange) {
            this.fEditor.commitUndoSnapshot();
            this.noChangesMade();
        }
        super.deactivate();
    }

    protected void noChangesMade() {
        this.didChange = false;
    }

    protected void changesMade() {
        this.didChange = true;
    }

    protected void intermediateUndoSnapshot() {
        if (this.didChange) {
            this.fEditor.commitUndoSnapshot();
            this.fEditor.prepareUndoSnapshot();
            this.noChangesMade();
        }
    }
}

