/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.BindingBadness;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class AssignBinder
implements Binder {
    Variable variable;
    boolean checkBound;

    public AssignBinder(Variable variable, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.variable = variable;
        this.checkBound = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bindingBadness(Searcher searcher) {
        int n;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (Unify.isBound(this.variable)) {
            return 1;
        }
        this.lock();
        try {
            Collection<? extends Object> collection = this.getCandidates(this.variable.getValue());
            n = BindingBadness.clip(collection.size());
        }
        finally {
            this.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (Unify.isBound(this.variable) && !this.checkBound) {
            searcher.search();
        } else {
            ArrayList<? extends Object> arrayList;
            TriggerableCollection triggerableCollection = this.getTriggerables();
            if (triggerableCollection != null) {
                searcher.insertTriggerable(triggerableCollection);
            }
            this.lock();
            try {
                arrayList = new ArrayList<Object>(this.getCandidates(this.variable.getValue()));
            }
            finally {
                this.unlock();
            }
            Collections.shuffle(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && !searcher.isCompleted()) {
                Object e = iterator.next();
                int n = searcher.recorder.checkpoint();
                try {
                    Unify.unify(this.variable, e, searcher.recorder);
                    searcher.search();
                }
                catch (Impossible impossible) {
                    // empty catch block
                }
                searcher.recorder.restore(n);
            }
        }
    }

    public abstract void lock();

    public abstract void unlock();

    public abstract Collection<? extends Object> getCandidates(Object var1);

    public abstract TriggerableCollection getTriggerables();
}

