/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;

public class SimulatorEvent {
    private StepIdentifier stepIdentifier = null;
    private SimulationEvent logObject;
    private NetInstance netInstance = null;
    private Object netElementInstance = null;

    public SimulatorEvent(SimulationEvent simulationEvent) throws Exception {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.logObject = simulationEvent;
        if (SimulatorPlugin.getCurrent() == null) {
            throw new Exception("No simulator running. Cant create Simulator Event.");
        }
        this.stepIdentifier = SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().currentStepIdentifier();
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent simulationEvent) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.stepIdentifier = stepIdentifier;
        this.logObject = simulationEvent;
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent simulationEvent, TransitionInstance transitionInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.stepIdentifier = stepIdentifier;
        this.logObject = simulationEvent;
        this.netElementInstance = transitionInstance;
        if (transitionInstance != null) {
            this.netInstance = transitionInstance.getNetInstance();
        }
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent simulationEvent, PlaceInstance placeInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.stepIdentifier = stepIdentifier;
        this.logObject = simulationEvent;
        this.netElementInstance = placeInstance;
        if (placeInstance != null) {
            this.netInstance = placeInstance.getNetInstance();
        }
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent simulationEvent, NetInstance netInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.stepIdentifier = stepIdentifier;
        this.logObject = simulationEvent;
        this.netInstance = netInstance;
    }

    public StepIdentifier getStep() {
        return this.stepIdentifier;
    }

    public SimulationEvent getMessage() {
        return this.logObject;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.stepIdentifier != null && this.stepIdentifier.getComponents().length > 0) {
            stringBuffer.append(this.stepIdentifier.toString());
        }
        stringBuffer.append(this.logObject.toString());
        return stringBuffer.toString();
    }

    public Object getNetElementInstance() {
        return this.netElementInstance;
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }
}

