/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.simulator.SimulationThreadPool;
import org.apache.log4j.Logger;

public class StepIdentifier
implements Comparable<StepIdentifier> {
    public static Logger logger = Logger.getLogger(StepIdentifier.class);
    private final long simulationRunId;
    private final long[] stepCountVector;

    public StepIdentifier(long l, long[] lArray) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.simulationRunId = l;
        this.stepCountVector = lArray;
    }

    public long[] getComponents() {
        return this.stepCountVector;
    }

    public long getSimulationRunId() {
        return this.simulationRunId;
    }

    public int hashCode() {
        if (this.stepCountVector.length >= 1) {
            return (int)this.stepCountVector[0];
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof StepIdentifier) {
            StepIdentifier stepIdentifier = (StepIdentifier)object;
            return this.compareTo(stepIdentifier) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (this.stepCountVector.length >= 1) {
            stringBuffer.append(Long.toString(this.stepCountVector[0]));
        }
        for (int i = 1; i < this.stepCountVector.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(Long.toString(this.stepCountVector[i]));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(StepIdentifier stepIdentifier) throws ClassCastException {
        StepIdentifier stepIdentifier2 = stepIdentifier;
        long[] lArray = stepIdentifier2.getComponents();
        if (this.getSimulationRunId() < stepIdentifier2.getSimulationRunId()) {
            return -1;
        }
        if (this.getSimulationRunId() < stepIdentifier2.getSimulationRunId()) {
            return 1;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > this.stepCountVector[i]) {
                return -1;
            }
            if (lArray[i] >= this.stepCountVector[i]) continue;
            return 1;
        }
        return 0;
    }
}

