/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.ChannelBinder;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.DeltaSet;
import de.renew.engine.searcher.DeltaSetFactory;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Variable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Searcher {
    public static Logger logger = Logger.getLogger(Searcher.class);
    private Finder finder;
    private Set<Binder> binders;
    private Set<Occurrence> occurrences;
    private Triggerable primaryTriggerable;
    private double earliestTime;
    public CalculationChecker calcChecker;
    public StateRecorder recorder;
    private Map<String, DeltaSet> deltaSets;

    public Searcher() {
        this(new HashSet<Occurrence>(), new HashMap<String, DeltaSet>());
    }

    protected Searcher(Triggerable triggerable, Finder finder) {
        this();
        this.primaryTriggerable = triggerable;
        this.finder = finder;
    }

    protected Searcher(Searcher searcher, Finder finder) {
        this(searcher.occurrences, searcher.deltaSets);
        this.primaryTriggerable = searcher.primaryTriggerable;
        this.finder = finder;
    }

    private Searcher(Set<Occurrence> set, Map<String, DeltaSet> map) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders = new HashSet<Binder>();
        this.occurrences = set;
        this.calcChecker = new CalculationChecker();
        this.recorder = new StateRecorder();
        this.deltaSets = map;
    }

    public boolean isCompleted() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.finder.isCompleted();
    }

    private void setPrimaryTriggerable(Triggerable triggerable) {
        if (triggerable != null) {
            triggerable.triggers().clear();
        }
        this.primaryTriggerable = triggerable;
    }

    protected Triggerable getPrimaryTriggerable() {
        return this.primaryTriggerable;
    }

    public void insertTriggerable(TriggerableCollection triggerableCollection) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.primaryTriggerable != null) {
            triggerableCollection.include(this.primaryTriggerable);
        }
    }

    public void addOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.occurrences.add(occurrence);
    }

    public void removeOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.occurrences.remove(occurrence);
    }

    public Collection<Occurrence> getOccurrences() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.occurrences;
    }

    public DeltaSet getDeltaSet(DeltaSetFactory deltaSetFactory) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        String string = deltaSetFactory.getCategory();
        DeltaSet deltaSet = this.deltaSets.get(string);
        if (deltaSet == null) {
            deltaSet = deltaSetFactory.createDeltaSet();
            this.deltaSets.put(string, deltaSet);
        }
        return deltaSet;
    }

    public double getEarliestTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.earliestTime;
    }

    private void setEarliestTime(double d) {
        this.earliestTime = d;
    }

    private Binder selectBestBinder() {
        Binder binder = null;
        int n = 10000;
        Iterator<Binder> iterator = this.binders.iterator();
        while (iterator.hasNext() && !this.isCompleted()) {
            Binder binder2 = iterator.next();
            int n2 = binder2.bindingBadness(this);
            if (n2 >= n) continue;
            binder = binder2;
            n = n2;
        }
        return binder;
    }

    public void search() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int n = this.recorder.checkpoint();
        if (!this.binders.isEmpty()) {
            Binder binder = this.selectBestBinder();
            if (binder != null && !this.isCompleted()) {
                this.removeBinder(binder);
                binder.bind(this);
                this.addBinder(binder);
            }
        } else if (this.calcChecker.isConsistent()) {
            double d = 0.0;
            for (DeltaSet deltaSet : this.deltaSets.values()) {
                d = Math.max(d, deltaSet.computeEarliestTime());
            }
            this.setEarliestTime(d);
            this.finder.found(this);
        }
        this.recorder.restore(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int n = this.recorder.checkpoint();
        try {
            Collection<Binder> collection = occurrence.makeBinders(this);
            this.addOccurrence(occurrence);
            this.addBinders(collection);
            this.search();
            this.removeBinders(collection);
            this.removeOccurrence(occurrence);
        }
        catch (Impossible impossible) {
        }
        finally {
            this.recorder.restore(n);
        }
    }

    public void addBinder(Binder binder) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.add(binder);
    }

    public void removeBinder(Binder binder) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.remove(binder);
    }

    public void addBinders(Collection<Binder> collection) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.addAll(collection);
    }

    public void removeBinders(Collection<Binder> collection) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.removeAll(collection);
    }

    private void startSearch() {
        this.recorder.restore();
        if (!this.occurrences.isEmpty() || !this.binders.isEmpty()) {
            throw new RuntimeException("Searcher was not in idle state at the start of a search.");
        }
    }

    public void searchAndRecover(Finder finder, Searchable searchable, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.startSearch();
        this.finder = finder;
        this.setPrimaryTriggerable(triggerable);
        this.earliestTime = 0.0;
        try {
            searchable.startSearch(this);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.binders.clear();
        this.occurrences.clear();
        this.calcChecker.reset();
        this.recorder.restore();
        this.deltaSets.clear();
        this.setPrimaryTriggerable(null);
        this.finder = null;
    }

    public void initiatedSearch(ChannelTarget channelTarget, String string, Variable variable, boolean bl, Finder finder, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.startSearch();
        this.finder = finder;
        this.setPrimaryTriggerable(triggerable);
        try {
            Variable variable2 = new Variable(channelTarget, this.recorder);
            ChannelBinder channelBinder = new ChannelBinder(variable2, string, variable, bl);
            this.addBinder(channelBinder);
            this.search();
            this.removeBinder(channelBinder);
            this.recorder.restore();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.binders.clear();
        this.occurrences.clear();
        this.calcChecker.reset();
        this.recorder.restore();
        this.deltaSets.clear();
        this.setPrimaryTriggerable(null);
        finder = null;
    }
}

