/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.DSQEnumeration;
import de.renew.engine.searchqueue.DSQListNode;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.simulator.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class DeterministicSearchQueue
implements SearchQueueData {
    private final double time;
    private DSQListNode list;
    private Hashtable<Searchable, DSQListNode> lookup;
    private int size = 0;

    DeterministicSearchQueue(double d) {
        this.time = d;
        this.list = null;
        this.lookup = new Hashtable();
    }

    @Override
    public double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.time;
    }

    @Override
    public void include(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        DSQListNode dSQListNode = this.lookup.get(searchable);
        if (dSQListNode == null) {
            ++this.size;
            dSQListNode = new DSQListNode(searchable);
            this.lookup.put(searchable, dSQListNode);
            if (this.list == null) {
                this.list = dSQListNode;
            } else {
                dSQListNode.prev = this.list.prev;
                dSQListNode.next = this.list;
                this.list.prev.next = dSQListNode;
                this.list.prev = dSQListNode;
            }
        }
    }

    private void discard(DSQListNode dSQListNode) {
        --this.size;
        this.lookup.remove(dSQListNode.elem);
        if (dSQListNode == dSQListNode.next) {
            this.list = null;
        } else {
            dSQListNode.next.prev = dSQListNode.prev;
            dSQListNode.prev.next = dSQListNode.next;
            if (this.list == dSQListNode) {
                this.list = dSQListNode.next;
            }
        }
    }

    @Override
    public void exclude(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        DSQListNode dSQListNode = this.lookup.get(searchable);
        if (dSQListNode != null) {
            this.discard(dSQListNode);
        }
    }

    @Override
    public Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.list == null) {
            return null;
        }
        Searchable searchable = this.list.elem;
        this.discard(this.list);
        return searchable;
    }

    @Override
    public Enumeration<Searchable> elements() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new DSQEnumeration(this.list);
    }

    @Override
    public int size() {
        return this.size;
    }
}

