/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TestTokenBag
implements Serializable {
    static final int maxStaticMult = 15;
    static final Integer[] multiplicities = new Integer[16];
    private int size = 0;
    private Map<Object, Integer> testCount = new HashMap<Object, Integer>();
    private Map<Object, Double> orgTime = new HashMap<Object, Double>();

    TestTokenBag() {
    }

    public synchronized int getUniqueSize() {
        return this.testCount.size();
    }

    public synchronized int getTestMultiplicity(Object object) {
        if (this.testCount.containsKey(object)) {
            return this.testCount.get(object);
        }
        return 0;
    }

    private static final Integer toInteger(int n) {
        if (n <= 15) {
            return multiplicities[n];
        }
        return new Integer(n);
    }

    public synchronized Collection<Object> uniqueElements() {
        return new ArrayList<Object>(this.testCount.keySet());
    }

    public synchronized boolean includesTested(Object object) {
        return this.testCount.containsKey(object);
    }

    synchronized void addTested(Object object, double d) {
        if (this.testCount.containsKey(object)) {
            Integer n = this.testCount.get(object);
            this.testCount.put(object, TestTokenBag.toInteger(n + 1));
        } else {
            this.testCount.put(object, TestTokenBag.toInteger(1));
            this.orgTime.put(object, new Double(d));
        }
        ++this.size;
    }

    synchronized double removeTested(Object object) {
        if (this.testCount.containsKey(object)) {
            int n = this.testCount.get(object) - 1;
            double d = this.orgTime.get(object);
            if (n == 0) {
                this.testCount.remove(object);
                this.orgTime.remove(object);
            } else {
                this.testCount.put(object, TestTokenBag.toInteger(n));
            }
            --this.size;
            return d;
        }
        throw new RuntimeException("Negative number of tokens detected.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TestTokenBag(size: ");
        stringBuffer.append(this.size);
        stringBuffer.append("; count'token@time:");
        for (Object object : this.testCount.keySet()) {
            stringBuffer.append(' ');
            stringBuffer.append(this.testCount.get(object));
            stringBuffer.append('\'');
            stringBuffer.append(object);
            stringBuffer.append('@');
            stringBuffer.append(this.orgTime.get(object));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            TestTokenBag.multiplicities[i] = new Integer(i);
        }
    }
}

